/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xmmd.fx;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.module.xmmd.common.XmmdConstants;
import jp.co.extreme.module.xmmd.fx.XmmdEventHandler;
import jp.co.extreme.module.xmmd.fx.XmmdModelEditor;
import jp.co.extreme.module.xmmd.model.XmmdModel;
import jp.co.extreme.module.xmmd.rmo.XmmdModelListRMO;
import jp.co.extreme.module.xmmd.stub.XmmdModelStub;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf4.fx.HfxLoadableTablePane;

public class XmmdModelListPane
extends FxDecoratePane
implements XmmdEventHandler {
    protected InnerTablePane tablePane = new InnerTablePane();
    protected Button button1;
    protected Button button2;
    protected Button button3;
    Integer schemaId;
    String tableName;
    protected Stage stage;

    public XmmdModelListPane() throws Exception {
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.button1 = this.createButton(BcWords.getInstance().add);
        this.button2 = this.createButton(BcWords.getInstance().open);
        this.button3 = this.createButton(BcWords.getInstance().close);
        this.setCenter((Node)this.tablePane);
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XmmdModelListRMO.class.getName());
        rmiReq.setMethodName("modeltList");
        this.tablePane.doLoad(rmiReq);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() != this.button1) {
            if (ev.getSource() == this.button2) {
                XmmdModel xmmdModel = XmmdModelStub.getInstance().getDataModel(this.schemaId, this.tableName);
                XmmdModelEditor modelEditor = new XmmdModelEditor();
                modelEditor.setData(xmmdModel);
                modelEditor.show(this.getScene().getWindow());
            } else if (ev.getSource() == this.button3) {
                this.close();
            }
        }
    }

    public void close() {
        this.stage.close();
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        this.stage.initOwner(ownerWindow);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.APPLICATION_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                BcLogUtil.debug("setOnShown");
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setResizable(true);
        this.stage.setWidth(800.0);
        this.stage.setHeight(600.0);
        this.stage.setTitle("Model List");
        this.stage.showAndWait();
    }

    @Override
    public void mmdSelected(Object obj) throws Exception {
        Integer modelId = (Integer)obj;
        XmmdModelEditor modelEditor = new XmmdModelEditor();
    }

    class InnerTablePane
    extends HfxLoadableTablePane {
        @Override
        protected TableView createTableView() throws Exception {
            HfxLoadableTablePane.InnerTableView tableView = new HfxLoadableTablePane.InnerTableView(this);
            tableView.setItems(FXCollections.observableArrayList());
            return tableView;
        }
    }

    class InnerTableView
    extends FxTableView {
        public InnerTableView() throws Exception {
            TableView.TableViewSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelectionMode(SelectionMode.SINGLE);
        }

        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            XmmdModelListPane.this.schemaId = (Integer)FxTableUtil.getCellValue((TableView)this, nextRowId, XmmdConstants.TableColmnName.xmmd_model__schema_id.value);
            XmmdModelListPane.this.tableName = (String)FxTableUtil.getCellValue((TableView)this, nextRowId, XmmdConstants.TableColmnName.xmmd_model__table_name.value);
            XmmdModelListPane.this.button2.setDisable(false);
        }
    }
}

