/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import java.awt.Desktop;
import java.io.File;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuBar;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javax.swing.SwingUtilities;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxxMouseEventUtil;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.tree.FxTreeView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.viewer.FxxImageView;
import jp.co.extreme.fx.viewer.FxxUrlEvent;
import jp.co.extreme.module.xdts.fx.XdtsMenuIF;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilExplorerPane;
import jp.co.extreme.module.xfil.fx.XfilFileCrawlDnDPane;
import jp.co.extreme.module.xfil.fx.XfilFileIndexListPane;
import jp.co.extreme.module.xfil.fx.XfilFileTreeView;
import jp.co.extreme.module.xfil.fx.XfilFxHelper;
import jp.co.extreme.module.xfil.fx.XfilIndexTreeBasePane;
import jp.co.extreme.module.xfil.fx.XfilMainViewPane;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.model.XfilUriEntityWrap;
import jp.co.extreme.module.xfil.swg.XfilCrawlerListPanel;
import jp.co.extreme.module.xfil.swg.XfilFileIndexListPanel;
import jp.co.extreme.module.xfil.swg.XfilIndexGroupListPanel;
import jp.co.extreme.scf3.stub.ScfDatabaseStub;
import jp.co.extreme.scf4.fx.HfxTaskMonitor;

public class XfilMenuPane
extends FxBorderPane
implements XdtsMenuIF {
    VBox vBox = new VBox(8.0);
    Button fileCrawlButton;
    Button indexListButton;
    Button addCrawlerButton;
    Button crawlerListButton;
    Button addindexGroupButton;
    Button indexGroupListButton;
    Button settingButton;
    Button indexListFxButton;
    Button tree1Button;
    Button tree2Button;
    Button dbCheckButton;
    double bw;
    double bh;

    public XfilMenuPane() throws Exception {
        this.fileCrawlButton = new Button(String.valueOf(BcWords.getInstance().dragAndDrop_abbreviation) + " " + XfilWords.getInstance().fileCrawl.toPlain());
        this.indexListButton = new Button(XfilWords.getInstance().indexList.toPlain());
        this.addCrawlerButton = new Button(XfilWords.getInstance().addCrawler.toPlain());
        this.crawlerListButton = new Button(XfilWords.getInstance().crawlerList.toPlain());
        this.addindexGroupButton = new Button(XfilWords.getInstance().addIndexGroup.toPlain());
        this.indexGroupListButton = new Button(XfilWords.getInstance().indexGroupList.toPlain());
        this.settingButton = new Button(XfilWords.getInstance().Setting.toPlain());
        this.indexListFxButton = new Button("Index List [FX]");
        this.tree1Button = new Button("Tree1");
        this.tree2Button = new Button("Tree2");
        this.dbCheckButton = new Button("DB Check");
        this.bw = 220.0;
        this.bh = 32.0;
        this.initComponant();
    }

    protected void initComponant() throws Exception {
        this.fileCrawlButton.setOnAction(this.actionEventHandler);
        this.fileCrawlButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.fileCrawlButton);
        this.indexListButton.setOnAction(this.actionEventHandler);
        this.indexListButton.setGraphic((Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
        this.indexListButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.indexListButton);
        this.addCrawlerButton.setOnAction(this.actionEventHandler);
        this.addCrawlerButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.addCrawlerButton);
        this.crawlerListButton.setOnAction(this.actionEventHandler);
        this.crawlerListButton.setGraphic((Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
        this.crawlerListButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.crawlerListButton);
        this.addindexGroupButton.setOnAction(this.actionEventHandler);
        this.addindexGroupButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.addindexGroupButton);
        this.indexGroupListButton.setOnAction(this.actionEventHandler);
        this.indexGroupListButton.setGraphic((Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
        this.indexGroupListButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.indexGroupListButton);
        this.settingButton.setOnAction(this.actionEventHandler);
        this.settingButton.setGraphic((Node)FxImageHelper.createImageView_icon("gear_64x64.png"));
        this.settingButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.settingButton);
        this.vBox.setAlignment(Pos.TOP_CENTER);
        this.setCenter((Node)this.vBox);
        HfxTaskMonitor.getInstance().show();
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileCrawlButton) {
            XfilFileCrawlDnDPane fileCrawlDnDPane = new XfilFileCrawlDnDPane();
            fileCrawlDnDPane.show(null);
        } else if (ev.getSource() == this.indexListButton) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        XfilFileIndexListPanel fileIndexListPanel = new XfilFileIndexListPanel();
                        fileIndexListPanel.init();
                        fileIndexListPanel.showAsFrame();
                    }
                    catch (Exception ex) {
                        XfilMenuPane.this.handleException(ex);
                    }
                }
            });
        } else if (ev.getSource() == this.addCrawlerButton) {
            XfilFxHelper.getInstance().openCrawlerPane(-1L);
        } else if (ev.getSource() == this.crawlerListButton) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        XfilCrawlerListPanel crawlerListPanel = new XfilCrawlerListPanel();
                        crawlerListPanel.init();
                        crawlerListPanel.showAsFrame();
                    }
                    catch (Exception ex) {
                        XfilMenuPane.this.handleException(ex);
                    }
                }
            });
        } else if (ev.getSource() == this.addindexGroupButton) {
            XfilFxHelper.getInstance().openIndexGroupPane(-1L);
        } else if (ev.getSource() == this.indexGroupListButton) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        XfilIndexGroupListPanel indexGroupListPanel = new XfilIndexGroupListPanel();
                        indexGroupListPanel.init();
                        indexGroupListPanel.showAsFrame();
                    }
                    catch (Exception ex) {
                        XfilMenuPane.this.handleException(ex);
                    }
                }
            });
        } else if (ev.getSource() == this.indexListFxButton) {
            XfilFileIndexListPane fileIndexListPane = new XfilFileIndexListPane();
            fileIndexListPane.show(null, false);
        } else if (ev.getSource() == this.settingButton) {
            XfilFxHelper.getInstance().openSettingPane();
        } else if (ev.getSource() == this.tree1Button) {
            XfilIndexTreeBasePane indexTreeBasePane = new XfilIndexTreeBasePane();
            indexTreeBasePane.show();
        } else if (ev.getSource() == this.tree2Button) {
            this.tree2();
        } else if (ev.getSource() == this.dbCheckButton) {
            ScfDatabaseStub.getInstance().checkDatasource();
        }
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().\u30d5\u30a1\u30a4\u30eb\u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3;
    }

    @Override
    public void setMenu(MenuBar menuBar) throws Exception {
    }

    @Override
    public ImageView getImageView() throws Exception {
        return FxImageHelper.createImageView_icon("schedule_64x64.png");
    }

    public void tree2() throws Exception {
        XfilFileTreeView fileTreeView = new XfilFileTreeView();
        XfilExplorerPane explorerPane = new XfilExplorerPane();
        explorerPane.addTab((Node)fileTreeView, 0);
        XfilMainViewPane mainViewPane = new XfilMainViewPane();
        mainViewPane.show(null);
        fileTreeView.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            if (ev.getEventType() == FxxUrlEvent.SELECTED) {
                try {
                    TreeItem treeItem = (TreeItem)ev.getSource();
                    BcLogUtil.debug("#### treeItem.getValue()=" + treeItem.getValue());
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)treeItem.getValue();
                    BcLogUtil.debug("uriEntityWrap.uri=" + uriEntityWrap.uri);
                    if (XfilFileTreeView.dummyUrl.equals(uriEntityWrap.uriStr)) {
                        File file = fileTreeView.getFile(treeItem);
                        fileTreeView.setFiles_L2(file.toPath(), treeItem);
                    }
                    List<XfilUriEntityWrap> uriEntityWrapList = XfilUtil.createUriEntityWrapList(uriEntityWrap.uri);
                    explorerPane.clear();
                    for (XfilUriEntityWrap uriEntityWrap2 : uriEntityWrapList) {
                        explorerPane.addUriEntityWrap(uriEntityWrap2);
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }));
        explorerPane.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            try {
                BcLogUtil.debug("FxxUrlEvent.URL_SELECTED:ev.getSource()=" + ev.getSource());
                if (ev.getEventType() == FxxUrlEvent.SELECTED) {
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)ev.getSource();
                    if (FxxMouseEventUtil.isImageExtention(uriEntityWrap.uri)) {
                        Image image = FxxMouseEventUtil.createBaseImage(uriEntityWrap.uri);
                        FxxImageView imageView = new FxxImageView(image);
                        mainViewPane.addNode((Node)imageView);
                    } else if (FxxMouseEventUtil.isMediaExtention(uriEntityWrap.uri)) {
                        // empty if block
                    }
                    fileTreeView.setUri(uriEntityWrap.uri);
                } else if (ev.getEventType() == FxxUrlEvent.EXE) {
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)ev.getSource();
                    if (!FxxMouseEventUtil.isImageExtention(uriEntityWrap.uri) && FxxMouseEventUtil.isMediaExtention(uriEntityWrap.uri)) {
                        File file = new File(uriEntityWrap.uri.getPath());
                        BcLogUtil.debug("file.getPath()=" + file.getPath() + " exists=" + file.exists());
                        if (file.exists()) {
                            Desktop.getDesktop().open(file);
                        }
                    }
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }));
        explorerPane.show(null);
    }

    protected class FavoriteTreeView<T>
    extends FxTreeView {
        public FavoriteTreeView(TreeItem<T> rootTreeItem) {
            super(rootTreeItem);
        }

        protected void selectionChanged(ObservableValue observable, TreeItem oldTreeItem, TreeItem newTreeItem) throws Exception {
            XfilUriEntity uriEntity = (XfilUriEntity)newTreeItem.getValue();
        }

        protected void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        }
    }
}

