/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;

public final class XfilTagUtil {
    public static final String delimiter = BcUnicode.Unicode.COMMA.string;
    public static final String EMPTY = BcUnicode.Unicode.COMMA.string;

    private XfilTagUtil() {
    }

    public static String toPersistenceString(Collection<String> tagCollection) throws Exception {
        if (BcCollectionUtil.isEmpty(tagCollection)) {
            return null;
        }
        List sortedList = tagCollection.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        String csv = BcCsvUtil.toCsv(sortedList);
        return BcStringUtil.sandwiche(csv, delimiter);
    }

    public static String toKeyword(CharSequence charSequence) throws Exception {
        return String.valueOf(delimiter) + charSequence;
    }

    public static String temp(String dbValue) throws Exception {
        if (BcStringUtil.isEmpty(dbValue)) {
            return null;
        }
        if (dbValue.startsWith(delimiter)) {
            dbValue = dbValue.substring(delimiter.length());
        }
        if (dbValue.endsWith(delimiter)) {
            dbValue = dbValue.substring(0, dbValue.length() - delimiter.length());
        }
        return dbValue;
    }
}

