/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.common;

public final class Wbs1Constants {
    public static final int TEXT_LENGTH = 16;
    public static final int POS_null = -1;
    public static final int POS_top = 1;
    public static final int POS_bottom = 2;
    public static final int POS_left = 3;
    public static final int POS_right = 4;
    public static final int[] positionIds = new int[]{-1, 1, 2, 3, 4};
    public static final String CLNM_article_id = ".id";
    public static final String CLNM_article_text_1 = ".text_1";
    public static final String CLNM_article_text_2 = ".text_1";
    public static final String DTS_access_log = "access_log";
    public static final String DTS_image_e01 = "image_e01";

    private Wbs1Constants() {
    }

    public static String getDatasourceName() throws Exception {
        return "dts_00000001";
    }

    public static ArticleContext ceateArticleContext(ArticleCategory articleCategory) throws Exception {
        ArticleContext articleContext = new ArticleContext();
        articleContext.articleCategory = articleCategory;
        if (articleCategory == ArticleCategory.article) {
            articleContext.featuredImage = true;
            articleContext.editorJs = true;
        }
        switch (articleCategory) {
            case article: {
                articleContext.title = "\u8a18\u4e8b";
                break;
            }
            case advertisement: {
                articleContext.title = "\u5e83\u544a";
                break;
            }
            case link: {
                articleContext.title = "\u30ea\u30f3\u30af";
                break;
            }
            case bulletinBoard: {
                articleContext.title = "\u63b2\u793a\u677f";
            }
        }
        return articleContext;
    }

    public static enum ArticleCategory {
        article(1, "wbs1_article"),
        advertisement(2, "wbs1_advertisement"),
        link(3, "wbs1_link"),
        bulletinBoard(4, "wbs1_bulletin_board");

        public final int id;
        public final String tableName;

        private ArticleCategory(int id, String tableName) {
            this.id = id;
            this.tableName = tableName;
        }

        public static ArticleCategory getById(int id) {
            ArticleCategory[] articleCategoryArray = ArticleCategory.values();
            int n = articleCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArticleCategory articleClass = articleCategoryArray[n2];
                if (articleClass.id == id) {
                    return articleClass;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class ArticleContext {
        public ArticleCategory articleCategory;
        public String title;
        public String description;
        public boolean featuredImage;
        public boolean editorJs;
    }

    public static enum ArticleItem {
        \u8868\u984c,
        \u672c\u6587,
        HTML,
        JSON;

    }

    public static enum ArticleParam {
        articleCategoryId,
        articleId;

    }

    public static enum Authority {
        \u7ba1\u7406\u8005("admin"),
        \u52e4\u6020\u7ba1\u7406("attendance");

        public final String code;

        private Authority(String code) {
            this.code = code;
        }
    }

    public static enum JudgementStatus {
        NULL(1),
        approval(1),
        denial(2);

        public final short id;

        private JudgementStatus(int value) {
            this.id = (short)value;
        }

        public static JudgementStatus getById(int id) {
            JudgementStatus[] judgementStatusArray = JudgementStatus.values();
            int n = judgementStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                JudgementStatus judgementStatus = judgementStatusArray[n2];
                if (judgementStatus.id == id) {
                    return judgementStatus;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum OperationMode {
        examination;

    }

    public static enum PointEvent {
        Join(101, 1000, true),
        Message(201, 10, false),
        Invite(301, 500, true);

        public final int id;
        public final int value;
        public final boolean addition;

        private PointEvent(int id, int value, boolean addition) {
            this.id = id;
            this.value = value;
            this.addition = addition;
        }
    }

    public static enum Requirement {
        NLLL(-1, null),
        n1_\u7d76\u5bfe\u51fa\u52e4\u3057\u305f\u3044(1, "\u7d76\u5bfe\u51fa\u52e4\u3057\u305f\u3044"),
        n2_\u51fa\u6765\u305f\u3089\u51fa\u52e4\u3057\u305f\u3044(2, "\u51fa\u6765\u305f\u3089\u51fa\u52e4\u3057\u305f\u3044"),
        n3_\u5fc5\u8981\u306a\u3089\u51fa\u52e4\u53ef\u80fd(3, "\u5fc5\u8981\u306a\u3089\u51fa\u52e4\u53ef\u80fd");

        public final short id;
        public final String dispName;

        private Requirement(int id, String dispName) {
            this.id = (short)id;
            this.dispName = dispName;
        }
    }

    public static enum siteKey {
        button,
        submit,
        reset;

    }
}

