/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.rmo;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.impt.dao.ImptDefineIndexDAO;
import jp.co.extreme.module.impt.dao.ImptFileResourceDAO;
import jp.co.extreme.module.impt.dao.ImptImportContextDAO;
import jp.co.extreme.module.impt.model.ImptDefineIndex;
import jp.co.extreme.module.impt.model.ImptImportContext;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf5.model.ScfFileResource;

public class ImptGeneralRMO
extends RmiAbstractRMO {
    public void getSourceRegistDirectry(RmiRmoArgument rmoArg) throws Exception {
        int defineIndexId = rmoArg.getRequest().getDataAsInteger();
        ImptImportContext importContext = new ImptImportContext();
        ImptImportContextDAO.getInstance().putImportContext(rmoArg.getDtsSession(this), importContext);
        File preserveBaseDir = new File(ApApplication.getInstance().toReal("${APP}data/import/"));
        try {
            File preserveDir;
            if (!preserveBaseDir.exists()) {
                preserveBaseDir.mkdirs();
            }
            if ((preserveDir = new File(preserveBaseDir, BcStringUtil.fillPrefix(importContext.getDataId(), 8, '0'))).exists()) {
                BcFileUtil.deleteFile(preserveDir);
            }
            preserveDir.mkdirs();
            if (defineIndexId > 0) {
                ImptDefineIndex defineIndex = ImptDefineIndexDAO.getInstance().getDefineIndex(rmoArg.getDtsSession(this), defineIndexId);
                ScfFileResource fileResource = ImptFileResourceDAO.getInstance().getFileResource(rmoArg.getDtsSession(this), defineIndex.fileResourceId);
                byte[] bytes = ImptFileResourceDAO.getInstance().getAsByteArray(rmoArg.getDtsSession(this).getConnection(), defineIndex.fileResourceId);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                File destFile = new File(preserveDir, fileResource.fileName);
                FileOutputStream os = new FileOutputStream(destFile.getPath(), false);
                BcStreamUtil.transmit(byteArrayInputStream, os, 4096);
                byteArrayInputStream.close();
                os.close();
            }
            rmoArg.getRespons().addData(importContext);
            rmoArg.getRespons().addData(preserveDir.getPath());
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            throw new Exception("\u30bd\u30fc\u30b9\u306e\u4fdd\u5b58\u306b\u304a\u3044\u3066\u30a8\u30e9\u30fc\u304c\u767a\u751f\u307e\u3057\u305f\u3002\n" + ex);
        }
    }
}

