/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.dcmn.swg;

import java.io.File;
import java.util.Properties;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.doc.util.DcfConstants;
import jp.co.extreme.module.dcmn.swg.DcmnReportPropertyPanel;
import jp.co.extreme.pdf.PdfConstants;
import jp.co.extreme.scf.client.ScfAbstractClientModule;
import jp.co.extreme.scf4.model.ScfMenuContext;
import jp.co.extreme.scf5.stub.ZScfDomainPropertyStub;
import jp.co.extreme.scf5.swg.IswgSharePropertyPanel;
import jp.co.extreme.swing.docviewer.DcfDocumentViewer;
import jp.co.extreme.swing.tree.BcTreeNode;

public class DcmnClientModule
extends ScfAbstractClientModule {
    protected File tempDir;
    public boolean docSaveEnabled;
    protected Properties replaceProps;

    public static DcmnClientModule getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void start() throws Exception {
        ApApplication application = ApApplication.getInstance();
        ScfMenuContext menuContext = new ScfMenuContext();
        menuContext.setMenuName("\u30ec\u30dd\u30fc\u30c8\u30fb\u5370\u5237(1)");
        menuContext.setJavaClassName(DcmnReportPropertyPanel.class.getName());
        IswgSharePropertyPanel.rootTreeNode.add(new BcTreeNode(menuContext));
        this.tempDir = new File(ApApplication.getInstance().toReal("${APP}temp/"));
        this.docSaveEnabled = true;
    }

    public Properties getReplaceProperties() throws Exception {
        if (this.replaceProps == null) {
            this.replaceProps = new Properties();
            String value = ZScfDomainPropertyStub.getInstance().getDomainProperty(1400110);
            if (!BcStringUtil.isEmpty(value)) {
                this.replaceProps.setProperty(DcfConstants.DEGN_signatureSectionName, value);
            }
            if (!BcStringUtil.isEmpty(value = ZScfDomainPropertyStub.getInstance().getDomainProperty(1400120))) {
                this.replaceProps.setProperty(DcfConstants.DEGN_signaturePersonName, value);
            }
        }
        return this.replaceProps;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void documentManagerCommonSetup(DcfDocumentViewer documentViewer, String title) throws Exception {
        documentViewer.setTempolaryDirectry(DcmnClientModule.getInstance().getTempDir());
        documentViewer.setTitle(title);
        String filePath = String.valueOf(ApApplication.getInstance().toReal("${APP}export/")) + title + "_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS() + PdfConstants.EXTENTION_dot_pdf;
        documentViewer.setOutputPdfFile(new File(filePath));
    }

    private static final class SingletonHolder {
        private static final DcmnClientModule instance = new DcmnClientModule();

        private SingletonHolder() {
        }
    }
}

