/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.parser;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.html.parser.HtmlParseEventHandler;

public class HtmlParser
extends BcLoggableObject {
    protected static final int MODE_init = 11;
    protected static final int MODE_tagName = 21;
    protected static final int MODE_attribute = 31;
    protected static final int MODE_attributeName = 32;
    protected static final int MODE_attributeValue1 = 33;
    protected static final int MODE_attributeValue2 = 34;
    protected HtmlParseEventHandler parseEventHandler;

    public HtmlParseEventHandler getParseEventHandler() {
        return this.parseEventHandler;
    }

    public void setParseEventHandler(HtmlParseEventHandler parseEventHandler) {
        this.parseEventHandler = parseEventHandler;
    }

    public void parse(String srcStr) throws Exception {
        if (BcStringUtil.isEmpty(srcStr)) {
            this.parseEnd();
            return;
        }
        StringBuilder sb = new StringBuilder(256);
        int pos = -1;
        char curChar = '\u0000';
        char preChar = '\u0000';
        int mode = 11;
        Object textElement = null;
        boolean isEndTag = false;
        while (true) {
            preChar = curChar;
            if (++pos < srcStr.length()) {
                curChar = srcStr.charAt(pos);
            } else {
                if (pos != srcStr.length()) break;
                curChar = '\u0000';
            }
            block0 : switch (mode) {
                case 11: {
                    switch (curChar) {
                        case '<': {
                            if (sb.length() > 0) {
                                this.handleText(sb.toString(), pos);
                                sb.delete(0, sb.length());
                            }
                            mode = 21;
                            isEndTag = false;
                            break;
                        }
                        case '\u0000': {
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            break;
                        }
                    }
                    break;
                }
                case 21: {
                    switch (curChar) {
                        case '/': {
                            isEndTag = true;
                            break;
                        }
                        case '>': {
                            if (isEndTag) {
                                this.handleEndTag(sb.toString(), pos);
                            } else {
                                this.handleStartTag(sb.toString(), pos);
                            }
                            sb.delete(0, sb.length());
                            mode = 11;
                            break;
                        }
                        case ' ': {
                            if (isEndTag) {
                                this.handleEndTag(sb.toString(), pos);
                            } else {
                                this.handleStartTag(sb.toString(), pos);
                            }
                            sb.delete(0, sb.length());
                            mode = 31;
                            break;
                        }
                        case '\u0000': {
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            break;
                        }
                    }
                    break;
                }
                case 31: {
                    switch (curChar) {
                        case '>': {
                            mode = 11;
                            break;
                        }
                        case '\u0000': 
                        case ' ': {
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            mode = 32;
                            break;
                        }
                    }
                    break;
                }
                case 32: {
                    switch (curChar) {
                        case '=': {
                            this.attributeName(sb.toString(), pos);
                            sb.delete(0, sb.length());
                            mode = 33;
                            break;
                        }
                        case '\u0000': {
                            break;
                        }
                        case ' ': {
                            if (sb.length() <= 0) break block0;
                            this.attributeName(sb.toString(), pos);
                            sb.delete(0, sb.length());
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            break;
                        }
                    }
                    break;
                }
                case 33: {
                    switch (curChar) {
                        case '\"': {
                            mode = 34;
                            break;
                        }
                    }
                    break;
                }
                case 34: {
                    switch (curChar) {
                        case '\"': {
                            this.attributeValue(sb.toString(), pos);
                            sb.delete(0, sb.length());
                            mode = 31;
                            break block0;
                        }
                        default: {
                            sb.append(curChar);
                        }
                    }
                }
            }
        }
        if (!BcStringUtil.isEmpty(sb)) {
            this.handleText(sb.toString(), pos);
        }
        this.parseEnd();
    }

    protected void handleStartTag(String tagName, int pos) throws Exception {
        this.parseEventHandler.handleStartTag(tagName, pos);
    }

    protected void handleEndTag(String tagName, int pos) throws Exception {
        this.parseEventHandler.handleEndTag(tagName, pos);
    }

    protected void attributeName(String attributeName, int pos) throws Exception {
        this.parseEventHandler.attributeName(attributeName, pos);
    }

    protected void attributeValue(String attributeValue, int pos) throws Exception {
        this.parseEventHandler.attributeValue(attributeValue, pos);
    }

    protected void handleText(String str, int pos) throws Exception {
        this.parseEventHandler.handleText(str, pos);
    }

    protected void parseEnd() throws Exception {
        this.parseEventHandler.parseEnd();
    }
}

