/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.util.Collection;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;

public class BcMessageCreator {
    public static BcMessageCreator getInstance() {
        return SingletonHolder.instance;
    }

    public String createMessage(Collection elementCollection, String lineSep, boolean hasNumber) {
        StringBuilder sb = new StringBuilder();
        int index = -1;
        for (Object element : elementCollection) {
            if (++index > 0) {
                sb.append(lineSep);
            }
            if (hasNumber) {
                sb.append("(" + (index + 1) + ") ");
            }
            if (element == null) continue;
            sb.append(element.toString());
        }
        return sb.toString();
    }

    public String createMessage(String subject, Collection elementCollection, String lineSep, boolean hasNumber) {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(subject)) {
            sb.append("-----[ ");
            sb.append(subject);
            sb.append(" ]-----");
            sb.append(lineSep);
        }
        sb.append(this.createMessage(elementCollection, lineSep, hasNumber));
        return sb.toString();
    }

    public String createMessage(String subject, Collection elementCollection, boolean hasNumber) {
        return this.createMessage(subject, elementCollection, BcStringUtil.lineSeparator, hasNumber);
    }

    public String createMessage(String subject, Collection elementCollection) {
        return this.createMessage(subject, elementCollection, true);
    }

    public String createMessage(Collection elementCollection) {
        return this.createMessage(null, elementCollection);
    }

    public String createMessage(BcResult result) {
        StringBuilder sb = new StringBuilder();
        if (result.hasInfo()) {
            sb.append(this.createMessage(BcWords.getInstance().information, result.getInfoList()));
        }
        if (result.hasWarn()) {
            if (sb.length() > 0) {
                sb.append(BcStringUtil.lineSeparator);
            }
            sb.append(this.createMessage(BcWords.getInstance().warning, result.getWarnList()));
        }
        if (result.hasError()) {
            if (sb.length() > 0) {
                sb.append(BcStringUtil.lineSeparator);
            }
            sb.append(this.createMessage(BcWords.getInstance().error, result.getErrorList()));
        }
        return sb.toString();
    }

    public String bindMessage(String msg, Object ... bindParams) {
        if (BcStringUtil.isEmpty(bindParams)) {
            return msg;
        }
        int i = 0;
        while (i < bindParams.length) {
            String str = BcStringUtil.toStringNotNull(bindParams[i]);
            msg = msg.replaceAll("\\{" + i + "\\}", str);
            ++i;
        }
        return msg;
    }

    private static final class SingletonHolder {
        private static final BcMessageCreator instance = new BcMessageCreator();

        private SingletonHolder() {
        }
    }
}

