/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.app.common;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.app.common.ApShutdownTask;
import jp.co.extreme.base.log.BcLogUtil;

public class ApShutdownManager
extends Thread {
    private List<ApShutdownTask> shutdownTaskList = new ArrayList<ApShutdownTask>();
    private int shutdownNoMax;
    private boolean isShutdown;

    private ApShutdownManager() {
        Runtime.getRuntime().addShutdownHook(this);
    }

    public static ApShutdownManager getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownTask(ApShutdownTask shutdownTask) {
        List<ApShutdownTask> list = this.shutdownTaskList;
        synchronized (list) {
            BcLogUtil.info("addShutdownTask:" + shutdownTask.getClass().getName());
            if (shutdownTask.getPriorityNo() > this.shutdownNoMax) {
                this.shutdownNoMax = shutdownTask.getPriorityNo();
            }
            this.shutdownTaskList.add(shutdownTask);
        }
    }

    @Override
    public void run() {
        BcLogUtil.info("Shutdown started. thread=" + Thread.currentThread().getName());
        try {
            this.shutdown();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    public void shutdown() throws Exception {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        int i = 0;
        while (i <= this.shutdownNoMax) {
            int j = 0;
            while (j < this.shutdownTaskList.size()) {
                ApShutdownTask shutdownTask = this.shutdownTaskList.get(j);
                if (shutdownTask.getPriorityNo() == i) {
                    BcLogUtil.info(BcLogUtil.createLabel("shutdown[" + i + "]:" + shutdownTask.getClass().getName(), "=", 8, 80));
                    try {
                        shutdownTask.shutdown(ApApplication.getInstance());
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    /* synthetic */ ApShutdownManager(ApShutdownManager apShutdownManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final ApShutdownManager instance = new ApShutdownManager(null);

        private SingletonHolder() {
        }
    }
}

