/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.viterbi;

import com.atilika.kuromoji.TokenizerBase;
import com.atilika.kuromoji.dict.ConnectionCosts;
import com.atilika.kuromoji.viterbi.MultiSearchResult;
import com.atilika.kuromoji.viterbi.ViterbiLattice;
import com.atilika.kuromoji.viterbi.ViterbiNode;
import com.atilika.kuromoji.viterbi.ViterbiSearcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class MultiSearcher {
    private final ConnectionCosts costs;
    private final TokenizerBase.Mode mode;
    private final ViterbiSearcher viterbiSearcher;
    private int baseCost;
    private List<Integer> pathCosts;
    private Map<ViterbiNode, SidetrackEdge> sidetracks;

    public MultiSearcher(ConnectionCosts costs, TokenizerBase.Mode mode, ViterbiSearcher viterbiSearcher) {
        this.costs = costs;
        this.mode = mode;
        this.viterbiSearcher = viterbiSearcher;
    }

    public MultiSearchResult getShortestPaths(ViterbiLattice lattice, int maxCount, int costSlack) {
        this.pathCosts = new ArrayList<Integer>();
        this.sidetracks = new HashMap<ViterbiNode, SidetrackEdge>();
        MultiSearchResult multiSearchResult = new MultiSearchResult();
        this.buildSidetracks(lattice);
        ViterbiNode eos = lattice.getEndIndexArr()[0][0];
        this.baseCost = eos.getPathCost();
        List<SidetrackEdge> paths = this.getPaths(eos, maxCount, costSlack);
        int i = 0;
        for (SidetrackEdge path : paths) {
            List<ViterbiNode> nodes = this.generatePath(eos, path);
            multiSearchResult.add(nodes, this.pathCosts.get(i));
            ++i;
        }
        return multiSearchResult;
    }

    private List<ViterbiNode> generatePath(ViterbiNode eos, SidetrackEdge sidetrackEdge) {
        LinkedList<ViterbiNode> result = new LinkedList<ViterbiNode>();
        ViterbiNode node = eos;
        result.add(node);
        while (node.getLeftNode() != null) {
            ViterbiNode leftNode = node.getLeftNode();
            if (sidetrackEdge != null && sidetrackEdge.getHead() == node) {
                leftNode = sidetrackEdge.getTail();
                sidetrackEdge = sidetrackEdge.getParent();
            }
            node = leftNode;
            result.addFirst(node);
        }
        return result;
    }

    private List<SidetrackEdge> getPaths(ViterbiNode eos, int maxCount, int costSlack) {
        SidetrackEdge sideTrackEdge;
        ArrayList<SidetrackEdge> result = new ArrayList<SidetrackEdge>();
        result.add(null);
        this.pathCosts.add(this.baseCost);
        PriorityQueue<SidetrackEdge> sidetrackHeap = new PriorityQueue<SidetrackEdge>();
        for (sideTrackEdge = this.sidetracks.get(eos); sideTrackEdge != null; sideTrackEdge = sideTrackEdge.getNextOption()) {
            sidetrackHeap.add(sideTrackEdge);
        }
        for (int i = 1; i < maxCount && !sidetrackHeap.isEmpty() && (sideTrackEdge = (SidetrackEdge)sidetrackHeap.poll()).getCost() <= costSlack; ++i) {
            result.add(sideTrackEdge);
            this.pathCosts.add(this.baseCost + sideTrackEdge.getCost());
            for (SidetrackEdge nextSidetrack = this.sidetracks.get(sideTrackEdge.getTail()); nextSidetrack != null; nextSidetrack = nextSidetrack.getNextOption()) {
                SidetrackEdge next = new SidetrackEdge(nextSidetrack.getCost(), nextSidetrack.getTail(), nextSidetrack.getHead());
                next.setParent(sideTrackEdge);
                sidetrackHeap.add(next);
            }
        }
        return result;
    }

    private void buildSidetracks(ViterbiLattice lattice) {
        ViterbiNode[][] startIndexArr = lattice.getStartIndexArr();
        ViterbiNode[][] endIndexArr = lattice.getEndIndexArr();
        for (int i = 1; i < startIndexArr.length; ++i) {
            if (startIndexArr[i] == null || endIndexArr[i] == null) continue;
            for (ViterbiNode node : startIndexArr[i]) {
                if (node == null) break;
                this.buildSidetracksForNode(endIndexArr[i], node);
            }
        }
    }

    private void buildSidetracksForNode(ViterbiNode[] leftNodes, ViterbiNode node) {
        int backwardConnectionId = node.getLeftId();
        int wordCost = node.getWordCost();
        ArrayList<SidetrackEdge> sidetrackEdges = new ArrayList<SidetrackEdge>();
        SidetrackEdge nextOption = this.sidetracks.get(node.getLeftNode());
        for (ViterbiNode leftNode : leftNodes) {
            if (leftNode == null) break;
            if (leftNode.getType() == ViterbiNode.Type.KNOWN && leftNode.getWordId() == -1) continue;
            int sideTrackCost = leftNode.getPathCost() - node.getPathCost() + wordCost + this.costs.get(leftNode.getRightId(), backwardConnectionId);
            if (this.mode == TokenizerBase.Mode.SEARCH || this.mode == TokenizerBase.Mode.EXTENDED) {
                sideTrackCost += this.viterbiSearcher.getPenaltyCost(node);
            }
            if (leftNode == node.getLeftNode()) continue;
            sidetrackEdges.add(new SidetrackEdge(sideTrackCost, leftNode, node));
        }
        if (sidetrackEdges.isEmpty()) {
            this.sidetracks.put(node, nextOption);
        } else {
            for (int i = 0; i < sidetrackEdges.size() - 1; ++i) {
                ((SidetrackEdge)sidetrackEdges.get(i)).setNextOption((SidetrackEdge)sidetrackEdges.get(i + 1));
            }
            ((SidetrackEdge)sidetrackEdges.get(sidetrackEdges.size() - 1)).setNextOption(nextOption);
            this.sidetracks.put(node, (SidetrackEdge)sidetrackEdges.get(0));
        }
    }

    private class SidetrackEdge
    implements Comparable<SidetrackEdge> {
        private int cost;
        private ViterbiNode tail;
        private ViterbiNode head;
        private SidetrackEdge nextOption;
        private SidetrackEdge parent;

        SidetrackEdge(int cost, ViterbiNode tail, ViterbiNode head) {
            this.cost = cost;
            this.tail = tail;
            this.head = head;
            this.nextOption = null;
            this.parent = null;
        }

        public int getCost() {
            return this.cost;
        }

        ViterbiNode getTail() {
            return this.tail;
        }

        ViterbiNode getHead() {
            return this.head;
        }

        public void setNextOption(SidetrackEdge nextOption) {
            this.nextOption = nextOption;
        }

        public SidetrackEdge getNextOption() {
            return this.nextOption;
        }

        public void setParent(SidetrackEdge parent) {
            this.parent = parent;
            this.cost += parent.cost;
        }

        public SidetrackEdge getParent() {
            return this.parent;
        }

        @Override
        public int compareTo(SidetrackEdge o) {
            return this.cost - o.getCost();
        }
    }
}

