/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IntegerArrayIO {
    private static final int INT_BYTES = 4;

    public static int[][] readArrays(InputStream input, int arrayCount) throws IOException {
        int[][] arrays = new int[arrayCount][];
        ReadableByteChannel channel = Channels.newChannel(input);
        for (int i = 0; i < arrayCount; ++i) {
            arrays[i] = IntegerArrayIO.readArrayFromChannel(channel);
        }
        return arrays;
    }

    public static void writeArray(OutputStream output, int[] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        ByteBuffer tmpBuffer = ByteBuffer.allocate(length * 4);
        IntBuffer intBuffer = tmpBuffer.asIntBuffer();
        tmpBuffer.rewind();
        intBuffer.put(array);
        WritableByteChannel channel = Channels.newChannel(dataOutput);
        channel.write(tmpBuffer);
    }

    public static int[][] readArray2D(InputStream input) throws IOException {
        DataInputStream dataInput = new DataInputStream(input);
        return IntegerArrayIO.readArrays(dataInput, dataInput.readInt());
    }

    public static void writeArray2D(OutputStream output, int[][] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        for (int i = 0; i < length; ++i) {
            IntegerArrayIO.writeArray(dataOutput, array[i]);
        }
    }

    public static int[][] readSparseArray2D(InputStream input) throws IOException {
        int index;
        ReadableByteChannel channel = Channels.newChannel(input);
        int arrayCount = IntegerArrayIO.readIntFromByteChannel(channel);
        int[][] arrays = new int[arrayCount][];
        while ((index = IntegerArrayIO.readIntFromByteChannel(channel)) >= 0) {
            arrays[index] = IntegerArrayIO.readArrayFromChannel(channel);
        }
        return arrays;
    }

    public static void writeSparseArray2D(OutputStream output, int[][] array) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(output);
        int length = array.length;
        dataOutput.writeInt(length);
        for (int i = 0; i < length; ++i) {
            int[] inner = array[i];
            if (inner == null) continue;
            dataOutput.writeInt(i);
            IntegerArrayIO.writeArray(dataOutput, inner);
        }
        dataOutput.writeInt(-1);
    }

    private static int readIntFromByteChannel(ReadableByteChannel channel) throws IOException {
        ByteBuffer intBuffer = ByteBuffer.allocate(4);
        int result = -1;
        while (intBuffer.hasRemaining() && channel.read(intBuffer) >= 0) {
        }
        if (!intBuffer.hasRemaining()) {
            intBuffer.rewind();
            result = intBuffer.asIntBuffer().get(0);
        }
        return result;
    }

    private static int[] readArrayFromChannel(ReadableByteChannel channel) throws IOException {
        int length = IntegerArrayIO.readIntFromByteChannel(channel);
        ByteBuffer tmpBuffer = ByteBuffer.allocate(length * 4);
        while (tmpBuffer.hasRemaining() && channel.read(tmpBuffer) >= 0) {
        }
        tmpBuffer.rewind();
        IntBuffer intBuffer = tmpBuffer.asIntBuffer();
        if (intBuffer.hasArray() && !intBuffer.isReadOnly()) {
            return intBuffer.array();
        }
        int[] array = new int[length];
        intBuffer.get(array);
        return array;
    }
}

