/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.fst;

import com.atilika.kuromoji.fst.Bits;
import com.atilika.kuromoji.io.ByteBufferIO;
import com.atilika.kuromoji.util.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class FST {
    public static final String FST_FILENAME = "fst.bin";
    private byte[] fst;
    private int[] jumpCache = new int[65536];
    private int[] outputCache = new int[65536];

    public FST(byte[] compiled) {
        this.fst = compiled;
        this.initCache();
    }

    public FST(InputStream input) throws IOException {
        this(ByteBufferIO.read(input).array());
    }

    private void initCache() {
        Arrays.fill(this.jumpCache, -1);
        Arrays.fill(this.outputCache, -1);
        int address = this.fst.length - 1;
        byte stateType = Bits.getByte(this.fst, address);
        int jumpBytes = (stateType & 3) + 1;
        int outputBytes = (stateType & 0x18) >> 3;
        int arcs = Bits.getShort(this.fst, --address);
        address -= 2;
        for (int i = 0; i < arcs; ++i) {
            int output = Bits.getInt(this.fst, address, outputBytes);
            int jump = Bits.getInt(this.fst, address -= outputBytes, jumpBytes);
            char label = (char)Bits.getShort(this.fst, address -= jumpBytes);
            address -= 2;
            this.jumpCache[label] = jump;
            this.outputCache[label] = output;
        }
    }

    public int lookup(String input) {
        int length = input.length();
        int address = this.fst.length - 1;
        int accumulator = 0;
        int index = 0;
        while (true) {
            byte stateTypByte = Bits.getByte(this.fst, address);
            int jumpBytes = (stateTypByte & 3) + 1;
            int outputBytes = (stateTypByte & 0x18) >> 3;
            int arcSize = 2 + jumpBytes + outputBytes;
            byte stateType = (byte)(stateTypByte & 0x80);
            --address;
            if (index == length) {
                if (stateType == 0) {
                    accumulator = 0;
                }
                return accumulator;
            }
            boolean matched = false;
            char c = input.charAt(index);
            if (index == 0) {
                int jump = this.jumpCache[c];
                if (jump == -1) {
                    return -1;
                }
                int output = this.outputCache[c];
                accumulator += output;
                address = jump;
                matched = true;
            } else {
                int numberOfArcs = Bits.getShort(this.fst, address);
                address -= 2;
                if (numberOfArcs == 0) {
                    return -1;
                }
                int high = numberOfArcs - 1;
                int low = 0;
                while (low <= high) {
                    int middle = low + (high - low) / 2;
                    int arcAddr = address - middle * arcSize;
                    char label = this.getArcLabel(arcAddr, outputBytes, jumpBytes);
                    if (label == c) {
                        matched = true;
                        address = this.getArcJump(arcAddr, outputBytes, jumpBytes);
                        accumulator += this.getArcOutput(arcAddr, outputBytes, jumpBytes);
                        break;
                    }
                    if (label > c) {
                        low = middle + 1;
                        continue;
                    }
                    high = middle - 1;
                }
            }
            if (!matched) {
                return -1;
            }
            ++index;
        }
    }

    private char getArcLabel(int arcAddress, int accumulateBytes, int jumpBytes) {
        return (char)Bits.getShort(this.fst, arcAddress - (accumulateBytes + jumpBytes));
    }

    private int getArcJump(int arcAddress, int accumulateBytes, int jumpBytes) {
        return Bits.getInt(this.fst, arcAddress - accumulateBytes, jumpBytes);
    }

    private int getArcOutput(int arcAddress, int accumulateBytes, int jumpBytes) {
        return Bits.getInt(this.fst, arcAddress, accumulateBytes);
    }

    public static FST newInstance(ResourceResolver resolver) throws IOException {
        return new FST(resolver.resolve(FST_FILENAME));
    }
}

