/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.dict;

import com.atilika.kuromoji.buffer.BufferEntry;
import com.atilika.kuromoji.buffer.StringValueMapBuffer;
import com.atilika.kuromoji.buffer.TokenInfoBuffer;
import com.atilika.kuromoji.buffer.WordIdMap;
import com.atilika.kuromoji.dict.Dictionary;
import com.atilika.kuromoji.util.DictionaryEntryLineParser;
import com.atilika.kuromoji.util.ResourceResolver;
import com.atilika.kuromoji.util.StringUtils;
import java.io.IOException;

public class TokenInfoDictionary
implements Dictionary {
    public static final String TOKEN_INFO_DICTIONARY_FILENAME = "tokenInfoDictionary.bin";
    public static final String FEATURE_MAP_FILENAME = "tokenInfoFeaturesMap.bin";
    public static final String POS_MAP_FILENAME = "tokenInfoPartOfSpeechMap.bin";
    public static final String TARGETMAP_FILENAME = "tokenInfoTargetMap.bin";
    private static final int LEFT_ID = 0;
    private static final int RIGHT_ID = 1;
    private static final int WORD_COST = 2;
    private static final int TOKEN_INFO_OFFSET = 3;
    private static final String FEATURE_SEPARATOR = ",";
    protected TokenInfoBuffer tokenInfoBuffer;
    protected StringValueMapBuffer posValues;
    protected StringValueMapBuffer stringValues;
    protected WordIdMap wordIdMap;

    public int[] lookupWordIds(int sourceId) {
        return this.wordIdMap.lookUp(sourceId);
    }

    @Override
    public int getLeftId(int wordId) {
        return this.tokenInfoBuffer.lookupTokenInfo(wordId, 0);
    }

    @Override
    public int getRightId(int wordId) {
        return this.tokenInfoBuffer.lookupTokenInfo(wordId, 1);
    }

    @Override
    public int getWordCost(int wordId) {
        return this.tokenInfoBuffer.lookupTokenInfo(wordId, 2);
    }

    @Override
    public String[] getAllFeaturesArray(int wordId) {
        int feature;
        int i;
        BufferEntry bufferEntry = this.tokenInfoBuffer.lookupEntry(wordId);
        int posLength = bufferEntry.posInfos.length;
        int featureLength = bufferEntry.featureInfos.length;
        boolean partOfSpeechAsShorts = false;
        if (posLength == 0) {
            posLength = bufferEntry.tokenInfos.length - 3;
            partOfSpeechAsShorts = true;
        }
        String[] result = new String[posLength + featureLength];
        if (partOfSpeechAsShorts) {
            for (i = 0; i < posLength; ++i) {
                feature = bufferEntry.tokenInfos[i + 3];
                result[i] = this.posValues.get(feature);
            }
        } else {
            for (i = 0; i < posLength; ++i) {
                feature = bufferEntry.posInfos[i] & 0xFF;
                result[i] = this.posValues.get(feature);
            }
        }
        for (i = 0; i < featureLength; ++i) {
            String s;
            feature = bufferEntry.featureInfos[i];
            result[i + posLength] = s = this.stringValues.get(feature);
        }
        return result;
    }

    @Override
    public String getAllFeatures(int wordId) {
        String[] features = this.getAllFeaturesArray(wordId);
        for (int i = 0; i < features.length; ++i) {
            String feature = features[i];
            features[i] = DictionaryEntryLineParser.escape(feature);
        }
        return StringUtils.join(features, FEATURE_SEPARATOR);
    }

    @Override
    public String getFeature(int wordId, int ... fields) {
        if (fields.length == 1) {
            return this.extractSingleFeature(wordId, fields[0]);
        }
        return this.extractMultipleFeatures(wordId, fields);
    }

    private String extractSingleFeature(int wordId, int field) {
        if (this.tokenInfoBuffer.isPartOfSpeechFeature(field)) {
            int featureId = this.tokenInfoBuffer.lookupPartOfSpeechFeature(wordId, field);
            return this.posValues.get(featureId);
        }
        int featureId = this.tokenInfoBuffer.lookupFeature(wordId, field);
        return this.stringValues.get(featureId);
    }

    private String extractMultipleFeatures(int wordId, int[] fields) {
        if (fields.length == 0) {
            return this.getAllFeatures(wordId);
        }
        if (fields.length == 1) {
            return this.extractSingleFeature(wordId, fields[0]);
        }
        String[] allFeatures = this.getAllFeaturesArray(wordId);
        String[] features = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            int featureNumber = fields[i];
            features[i] = DictionaryEntryLineParser.escape(allFeatures[featureNumber]);
        }
        return StringUtils.join(features, FEATURE_SEPARATOR);
    }

    public static TokenInfoDictionary newInstance(ResourceResolver resolver) throws IOException {
        TokenInfoDictionary dictionary = new TokenInfoDictionary();
        dictionary.setup(resolver);
        return dictionary;
    }

    private void setup(ResourceResolver resolver) throws IOException {
        this.tokenInfoBuffer = new TokenInfoBuffer(resolver.resolve(TOKEN_INFO_DICTIONARY_FILENAME));
        this.stringValues = new StringValueMapBuffer(resolver.resolve(FEATURE_MAP_FILENAME));
        this.posValues = new StringValueMapBuffer(resolver.resolve(POS_MAP_FILENAME));
        this.wordIdMap = new WordIdMap(resolver.resolve(TARGETMAP_FILENAME));
    }
}

