/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.buffer;

import com.atilika.kuromoji.io.ByteBufferIO;
import com.atilika.kuromoji.util.ScriptUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;

public class StringValueMapBuffer {
    private static final int INTEGER_BYTES = 4;
    private static final int SHORT_BYTES = 2;
    private static final short KATAKANA_FLAG = Short.MIN_VALUE;
    private static final short KATAKANA_LENGTH_MASK = Short.MAX_VALUE;
    private static final char KATAKANA_BASE = '\u3000';
    private ByteBuffer buffer;
    private int size;

    public StringValueMapBuffer(TreeMap<Integer, String> features) {
        this.put(features);
    }

    public StringValueMapBuffer(InputStream is) throws IOException {
        this.buffer = ByteBufferIO.read(new BufferedInputStream(is));
        this.size = this.buffer.getInt();
    }

    public String get(int key) {
        assert (key >= 0 && key < this.size);
        int keyIndex = (key + 1) * 4;
        int valueIndex = this.buffer.getInt(keyIndex);
        int length = this.buffer.getShort(valueIndex);
        if ((length & Short.MIN_VALUE) != 0) {
            return this.getKatakanaString(valueIndex + 2, length &= Short.MAX_VALUE);
        }
        return this.getString(valueIndex + 2, length);
    }

    private String getKatakanaString(int valueIndex, int length) {
        char[] string = new char[length];
        byte[] array = this.buffer.array();
        for (int i = 0; i < length; ++i) {
            string[i] = (char)(12288 + (array[valueIndex + i] & 0xFF));
        }
        return new String(string);
    }

    private String getString(int valueIndex, int length) {
        return new String(this.buffer.array(), valueIndex, length, StandardCharsets.UTF_16);
    }

    public void write(OutputStream output) throws IOException {
        ByteBufferIO.write(output, this.buffer);
    }

    private void put(TreeMap<Integer, String> strings) {
        int bufferSize = this.calculateSize(strings);
        this.size = strings.size();
        this.buffer = ByteBuffer.wrap(new byte[bufferSize]);
        this.buffer.putInt(0, this.size);
        int keyIndex = 4;
        int entryIndex = keyIndex + this.size * 4;
        for (String string : strings.values()) {
            this.buffer.putInt(keyIndex, entryIndex);
            entryIndex = this.put(entryIndex, string);
            keyIndex += 4;
        }
    }

    private int calculateSize(TreeMap<Integer, String> values) {
        int size = 4 + values.size() * 4;
        for (String value : values.values()) {
            size += 2 + this.getByteSize(value);
        }
        return size;
    }

    private int getByteSize(String string) {
        if (ScriptUtils.isKatakana(string)) {
            return string.length();
        }
        return this.getBytes(string).length;
    }

    private int put(int index, String value) {
        short length;
        byte[] bytes;
        boolean katakana = ScriptUtils.isKatakana(value);
        if (katakana) {
            bytes = this.getKatakanaBytes(value);
            length = (short)(bytes.length | 0x8000);
        } else {
            bytes = this.getBytes(value);
            length = (short)bytes.length;
        }
        assert (bytes.length < Short.MAX_VALUE);
        this.buffer.position(index);
        this.buffer.putShort(length);
        this.buffer.put(bytes);
        return index + 2 + bytes.length;
    }

    private byte[] getKatakanaBytes(String string) {
        int length = string.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            bytes[i] = (byte)(c - 12288);
        }
        return bytes;
    }

    private byte[] getBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_16);
    }
}

