/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiRenderer;

public final class JAnsiTextRenderer
implements TextRenderer {
    public static final Map<String, AnsiRenderer.Code[]> DefaultExceptionStyleMap;
    static final Map<String, AnsiRenderer.Code[]> DefaultMessageStyleMap;
    private static final Map<String, Map<String, AnsiRenderer.Code[]>> PrefedinedStyleMaps;
    private final String beginToken;
    private final int beginTokenLen;
    private final String endToken;
    private final int endTokenLen;
    private final Map<String, AnsiRenderer.Code[]> styleMap;

    static {
        HashMap<String, Map<String, AnsiRenderer.Code[]>> tempPreDefs = new HashMap<String, Map<String, AnsiRenderer.Code[]>>();
        HashMap<String, Object> map = new HashMap<String, AnsiRenderer.Code[]>();
        JAnsiTextRenderer.put(map, "Prefix", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Name", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "NameMessageSeparator", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Message", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE, AnsiRenderer.Code.BOLD);
        JAnsiTextRenderer.put(map, "At", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "CauseLabel", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Text", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "More", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Suppressed", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassLoaderName", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassLoaderSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleName", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleVersionSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleVersion", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleNameSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassName", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassMethodSeparator", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.MethodName", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.NativeMethod", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.FileName", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.LineNumber", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.Container", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.ContainerSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.UnknownSource", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Inexact", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Container", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.ContainerSeparator", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Location", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Version", AnsiRenderer.Code.YELLOW);
        DefaultExceptionStyleMap = Collections.unmodifiableMap(map);
        tempPreDefs.put("Spock", DefaultExceptionStyleMap);
        map = new HashMap();
        JAnsiTextRenderer.put(map, "Prefix", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Name", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW, AnsiRenderer.Code.BOLD);
        JAnsiTextRenderer.put(map, "NameMessageSeparator", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "Message", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE, AnsiRenderer.Code.BOLD);
        JAnsiTextRenderer.put(map, "At", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "CauseLabel", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Text", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "More", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Suppressed", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassLoaderName", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassLoaderSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleName", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleVersionSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleVersion", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ModuleNameSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassName", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassMethodSeparator", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.MethodName", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.NativeMethod", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.FileName", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.LineNumber", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.Container", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.ContainerSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.UnknownSource", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Inexact", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Container", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.ContainerSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Location", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Version", AnsiRenderer.Code.YELLOW);
        tempPreDefs.put("Kirk", Collections.unmodifiableMap(map));
        HashMap temp = new HashMap();
        DefaultMessageStyleMap = Collections.unmodifiableMap(temp);
        PrefedinedStyleMaps = Collections.unmodifiableMap(tempPreDefs);
    }

    private static void put(Map<String, AnsiRenderer.Code[]> map, String name, AnsiRenderer.Code ... codes) {
        map.put(name, codes);
    }

    public JAnsiTextRenderer(String[] formats, Map<String, AnsiRenderer.Code[]> defaultStyleMap) {
        Map<String, AnsiRenderer.Code[]> map;
        String tempEndToken;
        String tempBeginToken;
        block21: {
            block16: {
                tempBeginToken = "@|";
                tempEndToken = "|@";
                if (formats.length <= 1) break block16;
                String allStylesStr = formats[1];
                String[] allStyleAssignmentsArr = allStylesStr.split(" ");
                map = new HashMap<String, AnsiRenderer.Code[]>(allStyleAssignmentsArr.length + defaultStyleMap.size());
                map.putAll(defaultStyleMap);
                String[] stringArray = allStyleAssignmentsArr;
                int n = allStyleAssignmentsArr.length;
                int n2 = 0;
                while (n2 < n) {
                    block18: {
                        String[] codeNames;
                        String styleName;
                        block19: {
                            String[] styleAssignmentArr;
                            String styleAssignmentStr;
                            block17: {
                                styleAssignmentStr = stringArray[n2];
                                styleAssignmentArr = styleAssignmentStr.split("=");
                                if (styleAssignmentArr.length == 2) break block17;
                                StatusLogger.getLogger().warn("{} parsing style \"{}\", expected format: StyleName=Code(,Code)*", (Object)this.getClass().getSimpleName(), (Object)styleAssignmentStr);
                                break block18;
                            }
                            styleName = styleAssignmentArr[0];
                            String codeListStr = styleAssignmentArr[1];
                            codeNames = codeListStr.split(",");
                            if (codeNames.length != 0) break block19;
                            StatusLogger.getLogger().warn("{} parsing style \"{}\", expected format: StyleName=Code(,Code)*", (Object)this.getClass().getSimpleName(), (Object)styleAssignmentStr);
                            break block18;
                        }
                        switch (styleName) {
                            case "BeginToken": {
                                tempBeginToken = codeNames[0];
                                break;
                            }
                            case "EndToken": {
                                tempEndToken = codeNames[0];
                                break;
                            }
                            case "StyleMapName": {
                                String predefinedMapName = codeNames[0];
                                Map<String, AnsiRenderer.Code[]> predefinedMap = PrefedinedStyleMaps.get(predefinedMapName);
                                if (predefinedMap != null) {
                                    map.putAll(predefinedMap);
                                    break;
                                }
                                StatusLogger.getLogger().warn("Unknown predefined map name {}, pick one of {}", (Object)predefinedMapName, (Object)null);
                                break;
                            }
                            default: {
                                AnsiRenderer.Code[] codes = new AnsiRenderer.Code[codeNames.length];
                                int i = 0;
                                while (i < codes.length) {
                                    codes[i] = this.toCode(codeNames[i]);
                                    ++i;
                                }
                                map.put(styleName, codes);
                            }
                        }
                    }
                    ++n2;
                }
                break block21;
            }
            map = defaultStyleMap;
        }
        this.styleMap = map;
        this.beginToken = tempBeginToken;
        this.endToken = tempEndToken;
        this.beginTokenLen = tempBeginToken.length();
        this.endTokenLen = tempEndToken.length();
    }

    public Map<String, AnsiRenderer.Code[]> getStyleMap() {
        return this.styleMap;
    }

    private void render(Ansi ansi, AnsiRenderer.Code code) {
        if (code.isColor()) {
            if (code.isBackground()) {
                ansi.bg(code.getColor());
            } else {
                ansi.fg(code.getColor());
            }
        } else if (code.isAttribute()) {
            ansi.a(code.getAttribute());
        }
    }

    private void render(Ansi ansi, AnsiRenderer.Code ... codes) {
        AnsiRenderer.Code[] codeArray = codes;
        int n = codes.length;
        int n2 = 0;
        while (n2 < n) {
            AnsiRenderer.Code code = codeArray[n2];
            this.render(ansi, code);
            ++n2;
        }
    }

    private String render(String text, String ... names) {
        Ansi ansi = Ansi.ansi();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            AnsiRenderer.Code[] codes = this.styleMap.get(name);
            if (codes != null) {
                this.render(ansi, codes);
            } else {
                this.render(ansi, this.toCode(name));
            }
            ++n2;
        }
        return ansi.a(text).reset().toString();
    }

    @Override
    public void render(String input, StringBuilder output, String styleName) throws IllegalArgumentException {
        output.append(this.render(input, styleName));
    }

    @Override
    public void render(StringBuilder input, StringBuilder output) throws IllegalArgumentException {
        int i = 0;
        while (true) {
            int j;
            if ((j = input.indexOf(this.beginToken, i)) == -1) {
                if (i == 0) {
                    output.append((CharSequence)input);
                    return;
                }
                output.append(input.substring(i, input.length()));
                return;
            }
            output.append(input.substring(i, j));
            int k = input.indexOf(this.endToken, j);
            if (k == -1) {
                output.append((CharSequence)input);
                return;
            }
            String spec = input.substring(j += this.beginTokenLen, k);
            String[] items = spec.split(" ", 2);
            if (items.length == 1) {
                output.append((CharSequence)input);
                return;
            }
            String replacement = this.render(items[1], items[0].split(","));
            output.append(replacement);
            i = k + this.endTokenLen;
        }
    }

    private AnsiRenderer.Code toCode(String name) {
        return AnsiRenderer.Code.valueOf((String)Strings.toRootUpperCase(name));
    }

    public String toString() {
        return "JAnsiMessageRenderer [beginToken=" + this.beginToken + ", beginTokenLen=" + this.beginTokenLen + ", endToken=" + this.endToken + ", endTokenLen=" + this.endTokenLen + ", styleMap=" + this.styleMap + "]";
    }
}

