/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.net;

import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class SMTPOutputLogTarget
extends AbstractOutputTarget {
    private final Session m_session;
    private Message m_message;
    private final Address[] m_toAddresses;
    private final Address m_fromAddress;
    private final String m_subject;
    private int m_msgSize;
    private final int m_maxMsgSize;
    private StringBuffer m_buffer;
    private long m_bufferTime;
    private long m_maxDelayTime;
    private Thread m_runner;
    private boolean m_shutdown;
    private boolean m_debug;

    public SMTPOutputLogTarget(Session session, Address[] toAddresses, Address fromAddress, String subject, int maxMsgSize, int maxDelayTime, Formatter formatter) {
        super(formatter);
        this.m_maxMsgSize = maxMsgSize;
        this.m_toAddresses = toAddresses;
        this.m_fromAddress = fromAddress;
        this.m_subject = subject;
        this.m_session = session;
        this.m_maxDelayTime = maxDelayTime * 1000;
        if (this.m_maxDelayTime > 0L && this.m_maxMsgSize > 1) {
            this.m_runner = new Thread("SMTPOutputLogTarget_Queue_Daemon"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SMTPOutputLogTarget sMTPOutputLogTarget = SMTPOutputLogTarget.this;
                        synchronized (sMTPOutputLogTarget) {
                            try {
                                do {
                                    try {
                                        SMTPOutputLogTarget.this.wait(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (SMTPOutputLogTarget.this.m_message == null) continue;
                                    long now = System.currentTimeMillis();
                                    if (!SMTPOutputLogTarget.this.m_shutdown && SMTPOutputLogTarget.this.m_msgSize < SMTPOutputLogTarget.this.m_maxMsgSize && now - SMTPOutputLogTarget.this.m_bufferTime < SMTPOutputLogTarget.this.m_maxDelayTime) continue;
                                    SMTPOutputLogTarget.this.send();
                                } while (!SMTPOutputLogTarget.this.m_shutdown);
                            }
                            finally {
                                SMTPOutputLogTarget.this.m_runner = null;
                                SMTPOutputLogTarget.this.notifyAll();
                            }
                        }
                    }
                    catch (Throwable t) {
                        SMTPOutputLogTarget.this.getErrorHandler().error("Unexpected error in the SMTPOutputLogTarget queue daemon", t, null);
                    }
                }
            };
            this.m_runner.setDaemon(true);
            this.m_runner.start();
        }
        this.open();
    }

    public SMTPOutputLogTarget(Session session, Address[] toAddresses, Address fromAddress, String subject, int maxMsgSize, Formatter formatter) {
        this(session, toAddresses, fromAddress, subject, maxMsgSize, 0, formatter);
    }

    @Override
    protected synchronized void write(String data) {
        if (this.m_message == null) {
            try {
                this.m_session.setDebug(this.m_debug);
                this.m_message = new MimeMessage(this.m_session);
                this.m_message.setFrom(this.m_fromAddress);
                this.m_message.setRecipients(Message.RecipientType.TO, this.m_toAddresses);
                this.m_message.setSubject(this.m_subject);
                this.m_message.setSentDate(new Date());
            }
            catch (MessagingException e) {
                this.getErrorHandler().error("Error creating message", e, null);
                this.m_message = null;
                return;
            }
            this.m_buffer = new StringBuffer();
            this.m_bufferTime = System.currentTimeMillis();
            this.m_msgSize = 0;
        }
        this.m_buffer.append(data);
        if (!data.endsWith("\n")) {
            this.m_buffer.append("\n");
        }
        ++this.m_msgSize;
        if (this.m_runner == null) {
            if (this.m_msgSize >= this.m_maxMsgSize) {
                this.send();
            }
        } else {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this.m_runner == null) {
            this.send();
        } else {
            this.m_shutdown = true;
            this.notifyAll();
            while (this.m_runner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    private void send() {
        try {
            if (this.m_message != null && this.m_buffer != null) {
                this.m_message.setText(this.m_buffer.toString());
                Transport.send((Message)this.m_message);
                this.m_message = null;
            }
        }
        catch (MessagingException e) {
            this.getErrorHandler().error("Error sending message", e, null);
            this.m_message = null;
        }
    }
}

