/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.io.Serializable;
import java.util.Hashtable;

public final class ContextMap
implements Serializable {
    private static final ThreadLocal c_localContext = new InheritableThreadLocal();
    private final ContextMap m_parent;
    private Hashtable m_map = new Hashtable();
    private transient boolean m_readOnly;

    public static ContextMap getCurrentContext() {
        return ContextMap.getCurrentContext(true);
    }

    public static ContextMap getCurrentContext(boolean autocreate) {
        ContextMap context = (ContextMap)c_localContext.get();
        if (context == null && autocreate) {
            context = new ContextMap();
            c_localContext.set(context);
        }
        return context;
    }

    public static void removeCurrentContext() {
        c_localContext.set(null);
    }

    public static void bind(ContextMap context) {
        c_localContext.set(context);
    }

    public ContextMap() {
        this(null);
    }

    public ContextMap(ContextMap parent) {
        this.m_parent = parent;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void clear() {
        this.checkReadable();
        this.m_map.clear();
    }

    public Object get(String key, Object defaultObject) {
        Object object = this.get(key);
        if (object != null) {
            return object;
        }
        return defaultObject;
    }

    public Object get(String key) {
        if (key == null) {
            return null;
        }
        Object result = this.m_map.get(key);
        if (result == null && this.m_parent != null) {
            return this.m_parent.get(key);
        }
        return result;
    }

    public void set(String key, Object value) {
        this.checkReadable();
        if (value == null) {
            this.m_map.remove(key);
        } else {
            this.m_map.put(key, value);
        }
    }

    public int getSize() {
        return this.m_map.size();
    }

    private Object readResolve() {
        this.makeReadOnly();
        return this;
    }

    private void checkReadable() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("ContextMap is read only and can not be modified");
        }
    }
}

