/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import jp.co.extreme.swing.SwgPanel;

public class SwgControlPanel
extends SwgPanel {
    private static final long serialVersionUID = 6399675974101636803L;
    protected int xDiff = 4;
    protected int yDiff = 4;
    protected int rowCount = -1;
    protected boolean b1;

    public SwgControlPanel() throws Exception {
        this.setLayout(null);
    }

    @Override
    public Component add(Component component, int index) {
        Component component2 = super.add(component, index);
        this.calc();
        return component2;
    }

    @Override
    public Component add(Component component) {
        Component component2 = super.add(component, -1);
        this.calc();
        return component2;
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        super.componentResized(ev);
        this.calc();
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        super.componentResized(ev);
        this.calc();
    }

    protected void calc() {
        if (this.b1) {
            this.b1 = false;
        }
        if (this.getParent() == null) {
            return;
        }
        Component[] components = this.getComponents();
        if (components.length <= 0) {
            return;
        }
        Dimension dim1 = this.getSize();
        this.rowCount = 1;
        int x = this.xDiff;
        int y = this.yDiff;
        int rowHeight = 0;
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            rowHeight = Math.max(component.getPreferredSize().height, rowHeight);
            if (x + component.getPreferredSize().width > dim1.width - this.xDiff * 2) {
                ++this.rowCount;
                x = this.xDiff;
                y = (this.rowCount - 1) * (rowHeight + this.yDiff) + this.yDiff;
            }
            component.setLocation(x, y);
            component.setSize(component.getPreferredSize());
            x = x + component.getPreferredSize().width + this.xDiff;
            ++i;
        }
        Dimension dim2 = new Dimension(dim1.width, (rowHeight + this.yDiff) * this.rowCount);
        this.b1 = true;
        this.setPreferredSize(dim2);
        this.getParent().validate();
    }
}

