/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql.context;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.context.SqlContext;

public class SqlContext_Derby
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"org.apache.derby.jdbc.EmbeddedDriver"};
    public final int VARCHAR_MAX = 32672;
    public static final String URL_PREFIX = "jdbc:derby:";
    public static final String shutdown_true = "shutdown=true";
    public static final String SQL_STATE_XJ004 = "XJ004";
    public static final String SQL_STATE_XJ015 = "XJ015";
    public static final String SQL_STATE_08006 = "08006";

    public SqlContext_Derby(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getSqlType(SqlConnection sqlConn, String tableName, String columnName) throws Exception {
        String tableName2 = tableName.toUpperCase();
        String columnName2 = columnName.toUpperCase();
        return super.getSqlType(sqlConn, tableName2, columnName2);
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        return srcSql;
    }

    @Override
    public String getDateTimeFormatForCondition() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public static void shutdown(String dir) throws Exception {
        try {
            String url = null;
            url = BcStringUtil.isEmpty(dir) ? "jdbc:derby:;shutdown=true" : URL_PREFIX + dir + ";" + shutdown_true;
            BcLogUtil.debug("shutdown:url=" + url);
            Connection connection = DriverManager.getConnection(url);
        }
        catch (SQLException ex) {
            BcLogUtil.debug("ex.getSQLState()=" + ex.getSQLState());
            String successState = null;
            successState = BcStringUtil.isEmpty(dir) ? SQL_STATE_XJ015 : SQL_STATE_08006;
            if (BcStringUtil.equals(ex.getSQLState(), successState)) {
                BcLogUtil.debug("\u6b63\u5e38\u7d42\u4e86");
            }
            throw ex;
        }
    }
}

