/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.log.BcLoggableObject;

public class SqlConditionSpliter
extends BcLoggableObject {
    static final int MODE_init = 1;
    static final int MODE_value = 13;
    public char quorteChar = (char)34;
    public List<Character> delimiterCharList = new ArrayList<Character>();

    public SqlConditionSpliter() {
        this.delimiterCharList.add(Character.valueOf(' '));
        this.delimiterCharList.add(Character.valueOf('\t'));
        this.delimiterCharList.add(Character.valueOf(','));
    }

    public static SqlConditionSpliter getInstance() {
        return SingletonHolder.instance;
    }

    public List<String> split(String conditionSrc) throws Exception {
        ArrayList<String> conditionElementList = new ArrayList<String>();
        int pos = -1;
        char curChar = '\u0000';
        char preChar = '\u0000';
        int mode = 1;
        boolean isString = false;
        boolean isEscape = false;
        StringBuilder sb = new StringBuilder();
        while (++pos < conditionSrc.length()) {
            curChar = conditionSrc.charAt(pos);
            switch (mode) {
                case 1: {
                    if (this.isDelimiterChar(curChar)) {
                        this.addCondition(sb, false, conditionElementList);
                        break;
                    }
                    if (curChar == this.quorteChar) {
                        mode = 13;
                        break;
                    }
                    sb.append(curChar);
                    break;
                }
                case 13: {
                    if (curChar == this.quorteChar) {
                        this.addCondition(sb, true, conditionElementList);
                        mode = 1;
                        break;
                    }
                    sb.append(curChar);
                    break;
                }
            }
            preChar = curChar;
        }
        this.addCondition(sb, false, conditionElementList);
        return conditionElementList;
    }

    protected boolean isDelimiterChar(char aChar) throws Exception {
        return this.delimiterCharList.contains(Character.valueOf(aChar));
    }

    protected void addCondition(StringBuilder sb, boolean isText, List<String> conditionElementList) throws Exception {
        if (sb.length() > 0) {
            conditionElementList.add(sb.toString());
            sb.delete(0, sb.length());
        }
    }

    private static final class SingletonHolder {
        private static final SqlConditionSpliter instance = new SqlConditionSpliter();

        private SingletonHolder() {
        }
    }
}

