/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf8.util;

import java.util.List;
import java.util.Locale;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcKanaUtil;

public class KscfKeywordUtil {
    private KscfKeywordUtil() {
    }

    public static String conv(String src) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < src.length()) {
            char char_ = src.charAt(i);
            if (!BcStringUtil.isControlCharacter(char_) && char_ != ' ') {
                sb.append(char_);
            }
            ++i;
        }
        String str = BcKanaUtil.hanKanaToZenKana(sb.toString(), 2);
        str = BcKanaUtil.hiraganaToZenKana(str, 2);
        str = BcKanaUtil.zenKanaToSimple(str, 2);
        str = BcStringUtil.toLatinBasic(str, 2);
        str = str.toUpperCase(Locale.ENGLISH);
        return str;
    }

    public static void appenKeyword(StringBuilder sb, String word) throws Exception {
        if (BcStringUtil.isEmpty(word)) {
            return;
        }
        String words2 = KscfKeywordUtil.conv(word);
        List<String> tokenList = BcStringUtil.stringTokenize(words2, BcStringUtil.SPACE_STR, false, true);
        int i = 0;
        while (i < tokenList.size()) {
            String token = tokenList.get(i);
            int index = sb.indexOf(token);
            if (index < 0) {
                BcStringUtil.appendExceptEmpty(sb, ' ', token);
            }
            ++i;
        }
    }
}

