/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.module.dcmn.common.DcmcSimpleDocumentGenerator;
import jp.co.extreme.module.dcmn.stub.DcmnDocumentTemplateStub;
import jp.co.extreme.module.dcmn.swg.DcmnClientModule;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.scf3.client.ScfTableLoadEventHandler;
import jp.co.extreme.scf3.client.ScfTableLoadTask;
import jp.co.extreme.scf4.swg.HswgExportWizerd;
import jp.co.extreme.scf4.swg.HswgTableClateEventHandler;
import jp.co.extreme.scf4.swg.HswgTableDisplayContextPanel;
import jp.co.extreme.scf4.swg.HswgTableDisplayUtil;
import jp.co.extreme.scf4.table.ScfDisplayContext;
import jp.co.extreme.scf5.swg.IswgDocumentViewer;
import jp.co.extreme.swing.SwgBorderPanel;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgComponentUnit;
import jp.co.extreme.swing.SwgFormLayout;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgUtil;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;

public class IswgTableControlPanel2
extends SwgBorderPanel
implements ScfTableLoadEventHandler,
HswgTableClateEventHandler {
    private static final long serialVersionUID = 7031375402990893547L;
    protected SwgFormLayout formLayout1 = new SwgFormLayout(2);
    protected SwgFormLayout formLayout2 = new SwgFormLayout(2);
    protected SwgFormLayout formLayout3 = new SwgFormLayout(2);
    protected BcTableColumnModel tableColumnModel;
    protected BcTableModel tableModel;
    private BcTableContext tableContext;
    protected SwgTableView tableView;
    protected ScfDisplayContext displayContextOrigin;
    public SwgButton exportButton;
    public SwgButton printButton;
    public SwgButton selectAllButton;
    public SwgButton displaySettingButton;
    SwgComponentUnit displaySettingControlUnit;
    protected Dimension buttonSize = new Dimension(24, 24);
    protected List<Component> componentList3 = new ArrayList<Component>();

    public IswgTableControlPanel2() throws Exception {
        this.formLayout1.unitSpace = 4;
        this.formLayout1.topMargin = 4;
        this.westPanel.setLayout(this.formLayout1);
        this.formLayout2.unitSpace = 4;
        this.formLayout2.topMargin = 4;
        this.centerPanel.setLayout(this.formLayout2);
        this.formLayout3.unitSpace = 4;
        this.formLayout3.topMargin = 4;
        this.eastPanel.setLayout(this.formLayout3);
        this.setBorderSize(0, 0, 200, 20);
        this.setPreferredSize(new Dimension(200, 32));
    }

    public void addControl1(Component component) throws Exception {
        SwgComponentUnit componentUnit = new SwgComponentUnit(component, new Component[0]);
        this.formLayout1.componentUnitList.add(componentUnit);
    }

    public void addControl2(Component component) throws Exception {
        SwgComponentUnit componentUnit = new SwgComponentUnit(component, new Component[0]);
        this.formLayout2.componentUnitList.add(componentUnit);
    }

    public void addControl3(Component component, boolean flag) throws Exception {
        SwgComponentUnit componentUnit = new SwgComponentUnit(component, new Component[0]);
        this.formLayout2.componentUnitList.add(componentUnit);
        if (flag) {
            this.componentList3.add(component);
        }
    }

    public void addControl3(Component component) throws Exception {
        this.addControl3(component, true);
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.exportButton) {
            this.exportButtonAction();
        } else if (ev.getSource() == this.printButton) {
            this.printButtonAction();
        } else if (ev.getSource() == this.selectAllButton) {
            this.selectAllButtonAction();
        } else if (ev.getSource() == this.displaySettingButton) {
            this.displaySettingButtonAction();
        }
    }

    public void setControlEnabled2(boolean enabled) throws Exception {
        if (this.exportButton != null) {
            this.exportButton.setEnabled(enabled);
        }
        if (this.printButton != null) {
            this.printButton.setEnabled(enabled);
        }
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(enabled);
        }
        if (this.displaySettingButton != null) {
            this.displaySettingButton.setEnabled(enabled);
        }
    }

    public void setControlEnabled3(boolean enabled) throws Exception {
        SwgUtil.setEnabled(this.componentList3, enabled);
    }

    public void setExportButton() throws Exception {
        this.exportButton = new SwgButton();
        this.exportButton.addActionListener(this.actionListener);
        this.exportButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("export_64x64.png")));
        this.exportButton.setPreferredSize(this.buttonSize);
        this.exportButton.setToolTipText("\u73fe\u5728\u306e\u8868\u3092CSV\u306a\u3069\u306e\u5f62\u5f0f\u3067\u51fa\u529b\u3057\u307e\u3059\u3002");
        this.exportButton.setEnabled(false);
        this.addControl2(this.exportButton);
    }

    protected void exportButtonAction() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(ApApplication.getInstance().toReal("${APP}export/"));
        if (this.tableContext != null && !BcStringUtil.isEmpty(this.tableContext.title)) {
            sb.append(this.tableContext.title);
            sb.append("_");
        }
        sb.append(BcFileUtil.create_yyyyMMdd_HHmmssSSS());
        sb.append(String.valueOf(BcStringUtil.DOT_STR) + PoiConstants.Extention.csv.name());
        HswgExportWizerd exportWizerd = new HswgExportWizerd();
        exportWizerd.setData(this.tableModel, this.tableColumnModel);
        exportWizerd.setDestFile(new File(sb.toString()));
        exportWizerd.start(this);
    }

    public void setPrintButton() throws Exception {
        this.printButton = new SwgButton();
        this.printButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("printer_view_64x64.png")));
        this.printButton.addActionListener(this.actionListener);
        this.printButton.setPreferredSize(this.buttonSize);
        this.printButton.setToolTipText("\u73fe\u5728\u306e\u8868\u3092\u7c21\u6613\u5370\u5237\u3057\u307e\u3059\u3002");
        this.printButton.setEnabled(false);
        this.addControl2(this.printButton);
    }

    protected void printButtonAction() throws Exception {
        DcfPage templatePage = DcmnDocumentTemplateStub.getInstance().getDocForm("general_table.dfm");
        DcmcSimpleDocumentGenerator documentGenerator = new DcmcSimpleDocumentGenerator();
        documentGenerator.setTemplatePage(templatePage);
        DcfBook dcfBook = documentGenerator.doGenerate(this.tableModel, this.tableColumnModel, this.tableContext, DcmnClientModule.getInstance().getReplaceProperties());
        IswgDocumentViewer.printPreview_v1(dcfBook, this.tableContext.title);
    }

    public void setSelectAllButton() throws Exception {
        this.selectAllButton = new SwgButton();
        this.selectAllButton.addActionListener(this.actionListener);
        this.selectAllButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("table_selection_all_64x64.png")));
        this.selectAllButton.setPreferredSize(this.buttonSize);
        this.selectAllButton.setToolTipText("\u5168\u3066\u306e\u884c\u3092\u9078\u629e\u3057\u307e\u3059\u3002");
        this.selectAllButton.setEnabled(false);
        this.addControl2(this.selectAllButton);
    }

    protected void selectAllButtonAction() throws Exception {
    }

    public void setDisplaySettingButton(boolean disp) throws Exception {
        if (disp) {
            if (this.displaySettingButton == null) {
                this.displaySettingButton = new SwgButton();
                this.displaySettingButton.addActionListener(this.actionListener);
                this.displaySettingButton.setIcon(new ImageIcon(AwtImageHelper.getImageAsIcon("gear_64x64.png")));
                this.displaySettingButton.setPreferredSize(this.buttonSize);
                this.displaySettingButton.setToolTipText(BcWords.getInstance().configuration);
                this.displaySettingButton.setEnabled(false);
            }
            this.displaySettingControlUnit = new SwgComponentUnit((Component)this.displaySettingButton, new Component[0]);
            this.formLayout2.componentUnitList.add(this.displaySettingControlUnit);
        } else if (this.displaySettingButton != null) {
            this.formLayout2.componentUnitList.remove(this.displaySettingControlUnit);
            this.eastPanel.remove(this.displaySettingButton);
        }
    }

    public void displaySettingButtonDisable() throws Exception {
        if (this.displaySettingButton != null) {
            this.eastPanel.remove(this.displaySettingButton);
        }
    }

    protected void displaySettingButtonAction() throws Exception {
        IswgTableControlPanel2 ownerCompow = this;
        HswgTableDisplayContextPanel tableDisplayContextPanel = new HswgTableDisplayContextPanel();
        tableDisplayContextPanel.setTargetData((BcTableColumnModel)this.tableView.getColumnModel(), this.tableContext.title, this.displayContextOrigin);
        ScfDisplayContext displayContext = tableDisplayContextPanel.showAsDialog(ownerCompow);
        if (displayContext != null) {
            HswgTableDisplayUtil.applyDisplayContext(this.tableView, displayContext);
        }
    }

    public BcTableContext getTableContext() {
        return this.tableContext;
    }

    public void setTableContext(BcTableContext tableContext) {
        this.tableContext = tableContext;
    }

    @Override
    public void tableLoadStarted(ScfTableLoadTask tableLoadTask) throws Exception {
        this.setControlEnabled2(false);
        this.setControlEnabled3(false);
    }

    @Override
    public void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowCount, BcTableContext tableContext) throws Exception {
        this.setTableContext(tableContext);
    }

    @Override
    public void rowListReceived(ScfTableLoadTask tableLoadTask, List<List> rowList) throws Exception {
    }

    @Override
    public void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
        this.setControlEnabled2(eod);
    }

    @Override
    public void loadedRowSizeChanged(ScfTableLoadTask tableLoadTask, int rowCount, int loadedRowCount) throws Exception {
    }

    @Override
    public void generalResultReceived(ScfTableLoadTask tableLoadTask, Object generalResult) throws Exception {
    }

    @Override
    public void cancelStarted(ScfTableLoadTask tableLoadTask, Object source) throws Exception {
    }

    @Override
    public void canceled(ScfTableLoadTask tableLoadTask) throws Exception {
    }

    @Override
    public void tableLoadError(ScfTableLoadTask tableLoadTask, Throwable throwable) {
    }

    @Override
    public void tableModelCreated(BcTableModel tableModel) throws Exception {
        this.tableModel = tableModel;
        this.tableColumnModel = tableModel.getTableColumnModel();
    }

    @Override
    public void tableViewCreated(SwgTableView tableView) throws Exception {
        this.tableView = tableView;
    }
}

