/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.fx;

import java.util.HashMap;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.scf4.fx.HfxMemoryPane;
import jp.co.extreme.scf4.fx.HfxTaskConsolePane;
import jp.co.extreme.task.TskAbstractCallable;
import jp.co.extreme.task.TskCallableUnit;

class HfxTaskMonitorStage
extends BcLoggableObject {
    Map<String, HfxTaskConsolePane> consolePaneMap = new HashMap<String, HfxTaskConsolePane>();
    FxDecoratePane decoratePane = new FxDecoratePane();
    VBox vBox = new VBox();
    HfxMemoryPane memoryPane = new HfxMemoryPane();
    Stage stage;
    int width = 640;
    int headersize = 40;
    int height = 0;
    double insets = 8.0;
    double margin = 60.0;

    public HfxTaskMonitorStage() throws Exception {
        this.decoratePane.setCenter((Node)this.vBox);
        this.decoratePane.setBottom((Node)this.memoryPane);
        this.decoratePane.setPadding(new Insets(this.insets));
        this.memoryPane.start();
    }

    private Stage geStage() throws Exception {
        if (this.stage != null) {
            return this.stage;
        }
        this.stage = new Stage(StageStyle.DECORATED);
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    HfxTaskMonitorStage.this.windowShown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
            }
        });
        FxScene scene = new FxScene((Parent)this.decoratePane);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth((double)this.width);
        this.stage.setHeight((double)this.height);
        this.stage.setTitle("Task Monitor");
        this.stage.getIcons().add((Object)FxImageHelper.getImage("gear_64x64.png"));
        this.stage.setIconified(false);
        FxUtil.setWindowLowerLeft((Window)this.stage, this.margin);
        return this.stage;
    }

    public synchronized void show() throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HfxTaskMonitorStage.this.show2();
                }
                catch (Exception ex) {
                    HfxTaskMonitorStage.this.getLogger().error(ex);
                }
            }
        });
    }

    private synchronized void show2() throws Exception {
        Stage stage = this.geStage();
        if (stage.isShowing()) {
            stage.toFront();
        } else {
            stage.show();
        }
    }

    protected void windowShown() throws Exception {
    }

    public void hide() throws Exception {
        if (this.stage == null || !this.stage.isShowing()) {
            this.getLogger().warning("Stage is not showing.");
            return;
        }
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                HfxTaskMonitorStage.this.stage.hide();
            }
        });
    }

    protected void add(final TskCallableUnit callableUnit) throws Exception {
        if (this.consolePaneMap.containsKey(callableUnit.getId())) {
            return;
        }
        final TskAbstractCallable abstractCallable = callableUnit.callable;
        final HfxTaskConsolePane taskConsolePane = new HfxTaskConsolePane();
        abstractCallable.addEventHandler(taskConsolePane);
        this.consolePaneMap.put(callableUnit.getId(), taskConsolePane);
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FxUtil.defaultInitialize((Node)taskConsolePane);
                    HfxTaskMonitorStage.this.vBox.getChildren().add((Object)taskConsolePane);
                    HfxTaskMonitorStage.this.show2();
                    HfxTaskMonitorStage.this.resize(HfxTaskMonitorStage.this.vBox);
                    BcLogUtil.debug("abstractCallable.getTaskContext().startTime=" + abstractCallable.getTaskContext().startTime);
                    BcLogUtil.debug("callableUnit=" + callableUnit);
                    taskConsolePane.start(abstractCallable.getTaskContext().startTime, callableUnit.getName());
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected void remove(TskCallableUnit callableUnit) throws Exception {
        TskAbstractCallable abstractCallable = callableUnit.callable;
        abstractCallable.getLogger().bind(null);
        final HfxTaskConsolePane taskConsolePane = this.consolePaneMap.remove(callableUnit.getId());
        if (taskConsolePane == null) {
            return;
        }
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                taskConsolePane.stop();
                HfxTaskMonitorStage.this.vBox.getChildren().remove((Object)taskConsolePane);
                HfxTaskMonitorStage.this.resize(HfxTaskMonitorStage.this.vBox);
            }
        });
    }

    protected void resize(VBox vBox) {
        Node[] nodes = (Node[])vBox.getChildren().toArray((Object[])new Node[0]);
        double height = 0.0;
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            if (node instanceof Region) {
                Region region = (Region)node;
                height += region.getPrefHeight();
            }
            ++i;
        }
        height += (double)this.headersize;
        height += this.memoryPane.getPrefHeight();
        height += this.insets * 2.0;
        this.stage.setHeight(height += 40.0);
        FxUtil.setWindowLowerLeft((Window)this.stage, this.margin);
    }
}

