/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.fx;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.scf4.fx.HfxTaskMonitorStage;
import jp.co.extreme.task.TskAbstractCallable;
import jp.co.extreme.task.TskCallableUnit;
import jp.co.extreme.task.TskTaskEvent;
import jp.co.extreme.task.TskTaskManager;
import jp.co.extreme.task.TskTaskMonitor;

public class HfxTaskMonitor
extends BcLoggableObject
implements TskTaskMonitor,
BcEventHandler<TskTaskEvent> {
    private static Map<String, TskCallableUnit> callableUnitMap = new ConcurrentHashMap<String, TskCallableUnit>();
    private HfxTaskMonitorStage taskMonitorStage;

    public static HfxTaskMonitor getInstance() {
        return SingletonHolder.instance;
    }

    private HfxTaskMonitor() {
        try {
            this.taskMonitorStage = new HfxTaskMonitorStage();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        ValidationTask validationTask = new ValidationTask();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future future = executorService.submit(validationTask);
        TskTaskManager taskManager = TskTaskManager.getInstance();
        taskManager.setTaskMonitor(this);
        for (Map.Entry<String, TskCallableUnit> mapEntry : taskManager.getMap().entrySet()) {
            try {
                this.addCallableUnit(mapEntry.getValue());
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    protected void validation() throws Exception {
        TskTaskManager taskManager = TskTaskManager.getInstance();
        if (taskManager.getMap().size() <= 0) {
            this.hide();
        }
    }

    public void show() throws Exception {
        this.taskMonitorStage.show();
    }

    public void hide() throws Exception {
        this.taskMonitorStage.hide();
    }

    public void show(String title) throws Exception {
    }

    public void close() throws Exception {
    }

    public void appendData(String str) {
    }

    @Override
    public void addCallableUnit(TskCallableUnit callableUnit) throws Exception {
        TskCallableUnit callableUnit2 = callableUnitMap.get(callableUnit.getId());
        if (callableUnit2 != null) {
            return;
        }
        if (callableUnit.future != null && callableUnit.future.isDone()) {
            this.getLogger().debug("Callable is done. hashCode=" + callableUnit.callable.hashCode());
            return;
        }
        callableUnitMap.put(callableUnit.getId(), callableUnit);
        callableUnit.callable.addEventHandler(this);
        if (callableUnit.eventHandler != null) {
            return;
        }
        this.taskMonitorStage.add(callableUnit);
    }

    @Override
    public void handle(TskTaskEvent event) throws Exception {
        if (event.getEventType() == TskTaskEvent.EventType.Finished) {
            TskAbstractCallable callable = (TskAbstractCallable)event.getSource();
            TskCallableUnit callableUnit = callableUnitMap.remove(Integer.toString(callable.hashCode()));
            if (callableUnit != null) {
                this.taskMonitorStage.remove(callableUnit);
            }
        } else {
            event.getEventType();
        }
    }

    /* synthetic */ HfxTaskMonitor(HfxTaskMonitor hfxTaskMonitor) {
        this();
    }

    private static final class SingletonHolder {
        private static final HfxTaskMonitor instance = new HfxTaskMonitor(null);

        private SingletonHolder() {
        }
    }

    public class ValidationTask
    implements Callable {
        public final Object call() throws Exception {
            while (true) {
                try {
                    HfxTaskMonitor.this.validation();
                }
                catch (Exception ex) {
                    HfxTaskMonitor.this.getLogger().error(ex);
                }
                Thread.sleep(1000L);
            }
        }
    }
}

