/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf3.client;

import java.util.List;
import javax.swing.event.EventListenerList;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableContext;
import jp.co.extreme.rmi.client.RmiLocalAgent;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.stub.ScfHandleStub;
import jp.co.extreme.scf3.client.ScfTableLoadEventHandler;
import jp.co.extreme.scf3.stub.ScfDatabaseStub;
import jp.co.extreme.task.TskAbstractCallable;

public class ScfTableLoadTask
extends TskAbstractCallable {
    protected String handleId;
    protected int statusId;
    protected boolean eod;
    protected int requireRowCount = 100;
    private Integer rowCount;
    protected int loadedRowSize;
    private int requestCount;
    protected RmiRequest rmiReq1;
    private RmiRequest rmiReq2;
    protected RmiRespons handleRes;
    private List<BcTableColumn> tableColumnList;
    private RmiLocalAgent localAgent;
    private EventListenerList eventListenerList = new EventListenerList();

    public String getHandleId() {
        return this.handleId;
    }

    public RmiLocalAgent getLocalAgent() {
        return this.localAgent;
    }

    public void setLocalAgent(RmiLocalAgent localAgent) {
        this.localAgent = localAgent;
    }

    public ScfTableLoadTask() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this.statusId = Status.init.id;
        this.handleId = null;
        this.handleRes = null;
        this.eod = false;
        this.rowCount = -1;
        this.loadedRowSize = 0;
        this.requestCount = 0;
        this.tableColumnList = null;
    }

    public Object taskProcess() throws Exception {
        this.statusId = Status.running.id;
        if (this.handleRes == null) {
            this.tableLoadStarted(this);
            RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq1);
            this.setHandleRespons1(rmiRes);
        }
        try {
            this.rmiReq2 = ScfDatabaseStub.getInstance().getNextRecord(this.handleId, this.requireRowCount);
            while (!this.eod) {
                if (this.statusId != Status.running.id) {
                    break;
                }
                this.loadRows();
            }
        }
        finally {
            try {
                ScfHandleStub.getInstance().removeHandle(this.getLocalAgent(), this.handleId);
            }
            finally {
                this.statusId = Status.idling.id;
            }
        }
        this.tableLoadFinished(this, this.eod);
        return this.loadedRowSize;
    }

    public void setHandleRespons1(RmiRespons handleRes) throws Exception {
        this.handleRes = handleRes;
        if (handleRes.getStatusId() == -9) {
            throw handleRes.getException();
        }
        this.handleId = handleRes.getDataAsString("hId");
        Object tmpObject = handleRes.getObject("tableColumnList");
        if (tmpObject == null) {
            RmiRespons rmiRes = ScfDatabaseStub.getInstance().getTableHeader(this.getLocalAgent(), this.handleId);
            this.setHandleRespons2(rmiRes);
        } else {
            this.setHandleRespons2(handleRes);
        }
    }

    protected void setHandleRespons2(RmiRespons rmiRes2) throws Exception {
        boolean isOk = rmiRes2.getDataAsBoolean();
        if (isOk) {
            Object result = rmiRes2.getObject("tableColumnList");
            if (result instanceof List) {
                List tableColumnList = (List)rmiRes2.getObject("tableColumnList");
                this.rowCount = (Integer)rmiRes2.getObject("tb_rs");
                if (this.rowCount == null) {
                    this.rowCount = -1;
                }
                BcTableContext tableContext = (BcTableContext)rmiRes2.getObject("tb_ctx");
                this.tableColumnReceived(this, tableColumnList, this.rowCount, tableContext);
            } else {
                this.eod = true;
                this.generalResultReceived(this, result);
            }
        } else {
            Object reason = rmiRes2.getObject("result");
            String msg = null;
            if (reason != null) {
                this.statusId = Status.canceled.id;
                msg = reason.toString();
            } else {
                msg = "\u30c6\u30fc\u30d6\u30eb\u30d8\u30c3\u30c0\u53d6\u5f97\u306e\u5fdc\u7b54\u304c\u60f3\u5b9a\u5916\u3067\u3059\u3002";
            }
            throw new Exception(msg);
        }
    }

    protected void loadRows() throws Exception {
        List rowList;
        ++this.requestCount;
        RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq2);
        Integer eodNum = (Integer)rmiRes.getObject("eod");
        if (eodNum != null) {
            boolean bl = this.eod = eodNum == BcConstants.Existence.TRUE.value;
        }
        if ((rowList = (List)rmiRes.getObject("tb_rl")) != null) {
            this.rowListReceived(this, rowList);
        }
    }

    public RmiRequest getRequest() {
        return this.rmiReq1;
    }

    public void setRequest(RmiRequest rmiReq1) throws Exception {
        this.rmiReq1 = rmiReq1;
    }

    protected void tableLoadStarted(ScfTableLoadTask tableLoadTask) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableLoadStarted(this);
            ++n2;
        }
    }

    protected void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowCount, BcTableContext tableContext) throws Exception {
        this.tableColumnList = tableColumnList;
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableColumnReceived(tableLoadTask, tableColumnList, rowCount, tableContext);
            ++n2;
        }
    }

    protected void rowListReceived(ScfTableLoadTask tableLoadTask, List<List> rowList) throws Exception {
        this.loadedRowSize += rowList.size();
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.rowListReceived(tableLoadTask, rowList);
            ++n2;
        }
        this.loadedRowSizeChanged(tableLoadTask, this.rowCount, this.loadedRowSize);
    }

    protected void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableLoadFinished(tableLoadTask, eod);
            ++n2;
        }
    }

    protected void loadedRowSizeChanged(ScfTableLoadTask tableLoadTask, int rowCount, int loadedRowCount) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.loadedRowSizeChanged(tableLoadTask, rowCount, loadedRowCount);
            ++n2;
        }
    }

    protected void generalResultReceived(ScfTableLoadTask tableLoadTask, Object generalResult) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.generalResultReceived(tableLoadTask, generalResult);
            ++n2;
        }
    }

    protected void cancelStarted(ScfTableLoadTask tableLoadTask, Object source) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.cancelStarted(tableLoadTask, source);
            ++n2;
        }
    }

    protected void canceled(ScfTableLoadTask tableLoadTask) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.canceled(tableLoadTask);
            ++n2;
        }
    }

    protected void tableLoadError(ScfTableLoadTask tableLoadTask, Throwable throwable) {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableLoadError(tableLoadTask, throwable);
            ++n2;
        }
    }

    public void cancel(Object source) throws Exception {
        if (this.statusId != Status.running.id) {
            return;
        }
        this.cancelStarted(this, source);
        this.statusId = Status.cancelling.id;
        RmiRespons rmiRes = ScfDatabaseStub.getInstance().cancelQuery(this.getLocalAgent(), this.handleId);
        this.statusId = Status.canceled.id;
    }

    @Override
    protected void handleException(Throwable throwable) {
        this.tableLoadError(this, throwable);
    }

    public List<BcTableColumn> getTableColumnList() {
        return this.tableColumnList;
    }

    public EventListenerList getEventListenerList() {
        return this.eventListenerList;
    }

    public static enum Status {
        init(0),
        idling(1),
        running(2),
        cancelling(3),
        canceled(4);

        public final int id;

        private Status(int value) {
            this.id = value;
        }
    }
}

