/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.co.extreme.base.charset.BcUtf8Util;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.util.BcCharacterCodingException;
import jp.co.extreme.base.util.BcHtmlConverter;
import jp.co.extreme.poi.PoiAbstractCsvWriter;
import jp.co.extreme.poi.PoiExportCondition;
import jp.co.extreme.poi.PoiExportEventHandler;

public class PoiCsvWriter4Table
extends PoiAbstractCsvWriter {
    BcHtmlConverter htmlParser = new BcHtmlConverter();

    public void writeRow(Writer writer, TableModel tableModel, TableColumnModel tableColumnModel, int rowId, int rowCount) throws Exception {
        int columnId = -1;
        int outpuCount = 0;
        try {
            int i = 0;
            while (i < tableColumnModel.getColumnCount()) {
                TableColumn tableColumn1 = tableColumnModel.getColumn(i);
                columnId = i;
                boolean columnEnabled = true;
                MmdField mmdField = null;
                if (BcTableColumn.class.isAssignableFrom(tableColumn1.getClass())) {
                    BcTableColumn tableColumn2 = (BcTableColumn)tableColumn1;
                    columnEnabled = this.isColumnEnabled(tableColumn2);
                    mmdField = tableColumn2.getMmdField();
                    columnId = tableColumn2.getModelIndex();
                }
                if (columnEnabled) {
                    if (outpuCount > 0) {
                        this.write(writer, this.exportCondition.fieldSeparator);
                    }
                    ++outpuCount;
                    Object value = tableModel.getValueAt(rowId, columnId);
                    this.writeValue(writer, value, mmdField);
                }
                ++i;
            }
            PoiExportEventHandler[] exportEventHandlers = this.exportEventHandlerList.toArray(new PoiExportEventHandler[0]);
            int i2 = 0;
            while (i2 < exportEventHandlers.length) {
                try {
                    exportEventHandlers[i2].rowExported(tableModel, rowId);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                ++i2;
            }
        }
        catch (BcCharacterCodingException ex) {
            ex.position = String.valueOf(BcStringUtil.toStringNotNull(ex.position)) + " columnId=" + columnId;
            throw ex;
        }
    }

    public boolean isRowEnabled(TableModel tableModel, TableColumnModel tableColumnModel, int rowId) throws Exception {
        return true;
    }

    public boolean isColumnEnabled(TableColumn tableColumn) throws Exception {
        BcTableColumn lbTableColumn;
        boolean enabled = true;
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass()) && !(lbTableColumn = (BcTableColumn)tableColumn).getVisible() && !this.exportCondition.notVisibleEnabled) {
            enabled = false;
        }
        return enabled;
    }

    public void writeRows(Writer writer, TableModel tableModel, TableColumnModel tableColumnModel) throws Exception {
        if (tableModel.getRowCount() <= 0) {
            return;
        }
        int rowId = -1;
        int rowCount = 0;
        try {
            int i = 0;
            while (i < tableModel.getRowCount()) {
                rowId = i;
                boolean rowEnabled = this.isRowEnabled(tableModel, tableColumnModel, rowId);
                if (rowEnabled) {
                    if (rowCount > 0) {
                        this.write(writer, this.exportCondition.lineSeparator);
                    }
                    this.writeRow(writer, tableModel, tableColumnModel, rowId, ++rowCount);
                }
                ++i;
            }
            if (this.exportCondition.lineSeparatorLast) {
                this.write(writer, this.exportCondition.lineSeparator);
            }
        }
        catch (BcCharacterCodingException ex) {
            ex.position = String.valueOf(BcStringUtil.toStringNotNull(ex.position)) + " row=" + rowId;
            throw ex;
        }
    }

    public void writeTable(Writer writer, TableModel tableModel, TableColumnModel tableColumnModel, boolean headerEnabled) throws Exception {
        if (headerEnabled) {
            this.writeHeader(writer, tableColumnModel);
            this.write(writer, this.exportCondition.lineSeparator);
        }
        this.writeRows(writer, tableModel, tableColumnModel);
    }

    public void writeTable(Writer writer, TableModel tableModel, TableColumnModel tableColumnModel) throws Exception {
        this.writeTable(writer, tableModel, tableColumnModel, this.exportCondition.headerEnabled);
    }

    public void writeColumn(Writer writer, TableColumn tableColumn) throws Exception {
        Object value;
        String value2;
        BcTableColumn bcTableColumn;
        MmdField mmdField;
        String textValue = null;
        if (BcTableColumn.class.isAssignableFrom(tableColumn.getClass()) && (mmdField = (bcTableColumn = (BcTableColumn)tableColumn).getMmdField()) != null && (value2 = mmdField.nameForExport) != null) {
            textValue = this.htmlParser.toPlain(value2.toString(), true).toString();
        }
        if (BcStringUtil.isEmpty(textValue) && (value = tableColumn.getHeaderValue()) != null) {
            textValue = this.htmlParser.toPlain(value.toString(), true).toString();
        }
        this.writeValue(writer, textValue, null);
    }

    public void writeHeader(Writer writer, TableColumnModel tableColumnModel) throws Exception {
        int outputCount = 0;
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (this.isColumnEnabled(tableColumn)) {
                if (outputCount > 0) {
                    this.write(writer, this.exportCondition.fieldSeparator);
                }
                this.writeColumn(writer, tableColumn);
                ++outputCount;
            }
            ++i;
        }
    }

    public void writeTable(PoiExportCondition exportCondition, TableColumnModel tableColumnModel, TableModel tableModel, File destFile) throws Exception {
        this.setCondition(exportCondition);
        this.getLogger().debug("outputTable:rowCount=" + tableModel.getRowCount() + " destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        try (FileOutputStream os = new FileOutputStream(destFile, false);){
            if (BcStringUtil.equalsIgnoreCase(exportCondition.encoding, "UTF-8") && exportCondition.bomEnabled) {
                os.write(BcUtf8Util.bomBytes);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, exportCondition.encoding);){
                this.writeTable(writer, tableModel, tableColumnModel);
                writer.flush();
            }
        }
    }
}

