/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcWords;

public final class PoiConstants {
    public static final String quotationMark = BcStringUtil.DOUBLE_QUOTATION_STR;
    public static char[] ESCAPE_SEQENCE_CHARS = new char[]{'\n', '\r', '\"', ','};

    private PoiConstants() {
    }

    public static enum Extention {
        csv,
        tsv,
        xls,
        xlsx;

    }

    public static enum FieldSeparator {
        COMMA(BcStringUtil.COMMA_STR, BcWords.getInstance().comma),
        TAB(BcStringUtil.HORIZONTAL_TAB_STR, BcWords.getInstance().tab);

        public final String separator;
        public final String note;

        private FieldSeparator(String separator, String note) {
            this.separator = separator;
            this.note = note;
        }

        public static FieldSeparator getBySeparator(String separator) {
            FieldSeparator[] fieldSeparatorArray = FieldSeparator.values();
            int n = fieldSeparatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldSeparator fieldSeparator = fieldSeparatorArray[n2];
                if (fieldSeparator.separator.equals(separator)) {
                    return fieldSeparator;
                }
                ++n2;
            }
            return null;
        }

        public static String getNoteBySeparator(String separator) {
            FieldSeparator fieldSeparator = FieldSeparator.getBySeparator(separator);
            if (fieldSeparator != null) {
                return fieldSeparator.note;
            }
            return null;
        }

        public static String getSeparatorByNote(String note) {
            FieldSeparator[] fieldSeparatorArray = FieldSeparator.values();
            int n = fieldSeparatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldSeparator fieldSeparator = fieldSeparatorArray[n2];
                if (fieldSeparator.note.equals(note)) {
                    return fieldSeparator.separator;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum QuotationMarkPolicy {
        necessary(1, "\u5fc5\u8981\u306b\u5fdc\u3058\u3066\u4ed8\u52a0"),
        always(2, "\u5e38\u306b\u4ed8\u52a0");

        public final int id;
        public final String note;

        private QuotationMarkPolicy(int id, String note) {
            this.id = id;
            this.note = note;
        }
    }
}

