/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.poi;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil_JP;
import jp.co.extreme.base.log.BcLogUtil;

public class PoiCellFormatUtil {
    static Locale locale = new Locale("ja", "JP", "JP");

    private PoiCellFormatUtil() {
    }

    public static CellDateFormat getFormt(int formatId) {
        CellDateFormat[] cellDateFormatArray = CellDateFormat.values();
        int n = cellDateFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            CellDateFormat elm = cellDateFormatArray[n2];
            if (elm.getFormatNo() == formatId) {
                return elm;
            }
            ++n2;
        }
        return CellDateFormat.NONE;
    }

    public static boolean contains(int formatNo) {
        CellDateFormat[] cellDateFormatArray = CellDateFormat.values();
        int n = cellDateFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            CellDateFormat cellDateFormat = cellDateFormatArray[n2];
            if (cellDateFormat.getFormatNo() == formatNo) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String formt(Date date, int formatNo) {
        BcLogUtil.debug("formt:.date=" + date + " formatNo=" + formatNo);
        CellDateFormat cellDateFormat = PoiCellFormatUtil.getFormt(formatNo);
        DateFormat dateFormat = cellDateFormat.getDateFormat();
        String str = dateFormat.format(date);
        BcLogUtil.debug("str=" + str);
        BcTimeUtil_JP.Era[] eraArray = BcTimeUtil_JP.Era.values();
        int n = eraArray.length;
        int n2 = 0;
        while (n2 < n) {
            BcTimeUtil_JP.Era era = eraArray[n2];
            if (str.indexOf(era.name()) >= 0) {
                str = BcStringUtil.replace((CharSequence)str, BcStringUtil.SLASH_STR, BcStringUtil.DOT_STR).toString();
            }
            str = BcStringUtil.replace((CharSequence)str, era.name(), era.getCode()).toString();
            ++n2;
        }
        return str;
    }

    static enum CellDateFormat {
        NONE(-1, new SimpleDateFormat("yyyy/MM/dd")),
        FORMAT_14(14, new SimpleDateFormat("yyyy/M/d")),
        FORMAT_56(56, new SimpleDateFormat("M\u6708d\u65e5", locale)),
        FORMAT_57(57, new SimpleDateFormat("GGGGyy/M/d", locale)),
        FORMAT_58(58, new SimpleDateFormat("GGGGyy\u5e74M\u6708d\u65e5", locale)),
        FORMAT_176(176, new SimpleDateFormat("GGGGyy/M/d", locale)),
        FORMAT_178(178, new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5\t", locale));

        private int formatNo;
        private DateFormat dateFormat;

        private CellDateFormat(int formatNo, DateFormat dateFormat) {
            this.formatNo = formatNo;
            this.dateFormat = dateFormat;
        }

        public DateFormat getDateFormat() {
            return this.dateFormat;
        }

        public int getFormatNo() {
            return this.formatNo;
        }
    }
}

