/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.orm.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.orm.entity.OrmAddition;
import jp.co.extreme.orm.entity.OrmAdditionAnnotation;
import jp.co.extreme.orm.entity.OrmPersistenceEntity;
import jp.co.extreme.orm.entity.OrmPersistenceField;
import jp.co.extreme.orm.persistence.OrmEntityContextManager;
import jp.co.extreme.orm.persistence.OrmPersistenceUtil;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlPreparedStatement;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlSetClause;
import jp.co.extreme.sql.model.SqlUpdateQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class OrmEntityContext
extends BcLoggableObject {
    private Class entityClass;
    private List<Field> fieldList;
    private List<Method> getterMethodList;
    private List<Method> setterMethodList;
    private List<String> columnNameList;
    private List<Field> primaryKeyFieldList;
    private List<Integer> primaryKeySqlTypeIdList;
    private List<Method> keyMethodList;
    private List<Integer> keyMethodSqlTypeIdList;
    private OrmPersistenceEntity persistenceEntity;
    private Map<String, SqlUpdateQuery> updateQueryMap = new HashMap<String, SqlUpdateQuery>();
    private Map<String, String> updateQueryTextMap = new HashMap<String, String>();
    private Map<String, SqlUpdateQuery> insertQueryMap = new HashMap<String, SqlUpdateQuery>();
    private Map<String, String> insertQueryTextMap = new HashMap<String, String>();
    private Map<String, List<Integer>> sqlTypeListMap = new HashMap<String, List<Integer>>();
    private Map<String, String> selectColumnPhraseMap = new HashMap<String, String>();
    private Map<String, SqlSelectQuery> selectQueryMap = new HashMap<String, SqlSelectQuery>();
    protected static final char ARRAY_INDEX_WILDCARD = '?';

    public OrmEntityContext(Class entityClass) throws Exception {
        this.entityClass = entityClass;
        this.persistenceEntity = entityClass.getAnnotation(OrmPersistenceEntity.class);
        if (this.persistenceEntity == null && OrmAddition.class.isAssignableFrom(entityClass)) {
            this.persistenceEntity = new OrmAdditionAnnotation();
        }
    }

    public synchronized List<Field> getFieldList() throws Exception {
        if (this.fieldList != null) {
            return this.fieldList;
        }
        this.fieldList = new ArrayList<Field>();
        Field[] fields = this.entityClass.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (OrmPersistenceUtil.isPersistence(field)) {
                this.fieldList.add(field);
            }
            ++i;
        }
        return this.fieldList;
    }

    public synchronized List<Method> getGetterMethodList() throws Exception {
        if (this.getterMethodList != null) {
            return this.getterMethodList;
        }
        this.getterMethodList = new ArrayList<Method>();
        Method[] methods = this.entityClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            OrmPersistenceField persistenceField;
            Method method = methods[i];
            if (BcReflectUtil.isGetterMethod(method) && (persistenceField = method.getAnnotation(OrmPersistenceField.class)) != null) {
                this.getterMethodList.add(method);
            }
            ++i;
        }
        return this.getterMethodList;
    }

    public synchronized List<Method> getSetterMethodList() throws Exception {
        if (this.setterMethodList != null) {
            return this.setterMethodList;
        }
        this.setterMethodList = new ArrayList<Method>();
        this.getGetterMethodList();
        int i = 0;
        while (i < this.getterMethodList.size()) {
            Method getterMethod = this.getterMethodList.get(i);
            String tempName = getterMethod.getName().substring(3);
            String setterMethodName = BcReflectUtil.toSetterMethod(tempName);
            Method setterMethod = this.entityClass.getMethod(setterMethodName, getterMethod.getReturnType());
            this.setterMethodList.add(setterMethod);
            ++i;
        }
        return this.setterMethodList;
    }

    public synchronized SqlUpdateQuery getUpdateQuery(SqlContext sqlContext, String tableName) throws Exception {
        SqlUpdateQuery updateQuery = this.updateQueryMap.get(tableName);
        if (updateQuery != null) {
            return updateQuery;
        }
        updateQuery = new SqlUpdateQuery();
        updateQuery.tableName = tableName;
        List<String> columnNameList = this.getColumnNameList(null);
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            SqlSetClause setClause = new SqlSetClause(columnName, null);
            updateQuery.addSetClause(setClause);
            ++i;
        }
        List<SqlWhereElement> whereElementList = OrmPersistenceUtil.createWhereClauseList(this.entityClass, this.persistenceEntity, null);
        updateQuery.getWhereElementList().addAll(whereElementList);
        this.setTimeStampFunction(sqlContext, updateQuery);
        this.updateQueryMap.put(tableName, updateQuery);
        return updateQuery;
    }

    public synchronized String getUpdateQueryText(SqlContext sqlContext, String tableName) throws Exception {
        String query = this.updateQueryTextMap.get(tableName);
        if (query != null) {
            return query;
        }
        SqlUpdateQuery updateQuery = this.getUpdateQuery(sqlContext, tableName);
        query = sqlContext.buildUpdateQueryForPrepareStatement(updateQuery);
        this.updateQueryTextMap.put(tableName, query);
        return query;
    }

    public synchronized SqlUpdateQuery getInsertQuery(SqlContext sqlContext, String tableName) throws Exception {
        SqlUpdateQuery insertQuery = this.insertQueryMap.get(tableName);
        if (insertQuery != null) {
            return insertQuery;
        }
        insertQuery = this.getUpdateQuery(sqlContext, tableName);
        this.insertQueryMap.put(tableName, insertQuery);
        return insertQuery;
    }

    public synchronized String getInsertQueryText(SqlContext sqlContext, String tableName) throws Exception {
        String query = this.insertQueryTextMap.get(tableName);
        if (query != null) {
            return query;
        }
        SqlUpdateQuery insertQuery = this.getInsertQuery(sqlContext, tableName);
        query = sqlContext.buildInsertQueryForPrepareStatement(insertQuery);
        this.insertQueryTextMap.put(tableName, query);
        return query;
    }

    public synchronized SqlSelectQuery getSelectQuery(SqlContext sqlContext, String tableName) throws Exception {
        SqlSelectQuery selectQuery = this.selectQueryMap.get(tableName);
        if (selectQuery != null) {
            return selectQuery;
        }
        selectQuery = new SqlSelectQuery();
        selectQuery.setFromClause(tableName);
        List<String> columnNameList = this.getColumnNameList(null);
        selectQuery.getSelectColumnList().addAll(columnNameList);
        List<SqlWhereElement> whereElementList = OrmPersistenceUtil.createWhereClauseList(this.entityClass, this.persistenceEntity, null);
        selectQuery.getWhereElementList().addAll(whereElementList);
        this.selectQueryMap.put(tableName, selectQuery);
        return selectQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getColumnNameList(String tableAlias) throws Exception {
        List<String> columnNameList2;
        OrmEntityContext ormEntityContext = this;
        synchronized (ormEntityContext) {
            if (this.columnNameList == null) {
                this.columnNameList = this.cretaeColumnNameList(null);
            }
        }
        if (BcStringUtil.isEmpty(tableAlias)) {
            columnNameList2 = this.columnNameList;
        } else {
            columnNameList2 = new ArrayList<String>();
            int i = 0;
            while (i < this.columnNameList.size()) {
                String columnName1 = this.columnNameList.get(i);
                String columnName2 = String.valueOf(tableAlias) + BcStringUtil.DOT_STR + columnName1;
                columnNameList2.add(columnName2);
                ++i;
            }
        }
        return columnNameList2;
    }

    public List<Integer> getSqlTypeList(DtsSession dtsSession, String tableName) throws Exception {
        List<Integer> sqlTypeList = this.sqlTypeListMap.get(tableName);
        if (sqlTypeList != null) {
            return sqlTypeList;
        }
        List<String> columnNameList = this.getColumnNameList(null);
        SqlContext sqlContext = dtsSession.getSqlContext();
        sqlTypeList = sqlContext.getSqlTypeList(dtsSession.getConnection(), tableName, columnNameList);
        this.sqlTypeListMap.put(tableName, sqlTypeList);
        return sqlTypeList;
    }

    public synchronized String getSelectColumnPhrase(String tableAlias) throws Exception {
        String phrase = this.selectColumnPhraseMap.get(tableAlias);
        if (phrase != null) {
            return phrase;
        }
        List<String> columnNameList = this.getColumnNameList(tableAlias);
        StringBuilder sb = new StringBuilder();
        sb.append(BcStringUtil.marge(columnNameList, String.valueOf(BcStringUtil.lineSeparator) + BcStringUtil.COMMA_STR + BcStringUtil.SPACE_STR));
        phrase = sb.toString();
        this.selectColumnPhraseMap.put(tableAlias, phrase);
        return phrase;
    }

    public synchronized List<Field> getPrimaryKeyFieldList(SqlConnection sqlConn, String tableName) throws Exception {
        if (this.primaryKeyFieldList != null) {
            return this.primaryKeyFieldList;
        }
        this.primaryKeyFieldList = new ArrayList<Field>();
        this.primaryKeySqlTypeIdList = new ArrayList<Integer>();
        if (!BcStringUtil.isEmpty(this.persistenceEntity.primaryKeyField())) {
            List<String> keyFieldNameList = BcStringUtil.stringTokenize(this.persistenceEntity.primaryKeyField(), ',', false, true);
            int i = 0;
            while (i < keyFieldNameList.size()) {
                Field field = this.entityClass.getField(keyFieldNameList.get(i));
                this.primaryKeyFieldList.add(field);
                int sqlTypeId = sqlConn.getSqlContext().getSqlType(sqlConn, tableName, OrmPersistenceUtil.toColumnName(this.persistenceEntity, field));
                this.primaryKeySqlTypeIdList.add(sqlTypeId);
                ++i;
            }
        }
        return this.primaryKeyFieldList;
    }

    public synchronized List<Method> getPrimaryKeyMethodList(SqlConnection sqlConn, String tableName) throws Exception {
        if (this.keyMethodList != null) {
            return this.keyMethodList;
        }
        this.keyMethodList = new ArrayList<Method>();
        this.keyMethodSqlTypeIdList = new ArrayList<Integer>();
        if (!BcStringUtil.isEmpty(this.persistenceEntity.primaryKeyMethod())) {
            List<String> keyMethodNameList = BcStringUtil.stringTokenize(this.persistenceEntity.primaryKeyMethod(), ',', false, true);
            int i = 0;
            while (i < keyMethodNameList.size()) {
                String methodName = keyMethodNameList.get(i);
                Method method = this.entityClass.getMethod(methodName, null);
                this.keyMethodList.add(method);
                OrmPersistenceField persistenceField = method.getAnnotation(OrmPersistenceField.class);
                int sqlTypeId = sqlConn.getSqlContext().getSqlType(sqlConn, tableName, persistenceField.columnName()[0]);
                this.keyMethodSqlTypeIdList.add(sqlTypeId);
                ++i;
            }
        }
        return this.keyMethodList;
    }

    public void setPrimaryKeyValue(DtsSession dtsSession, SqlPreparedStatement ppst, String tableName, BcInteger primaryKeyOffset, Object entity) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        List<Field> primaryKeyFieldList = this.getPrimaryKeyFieldList(dtsSession.getConnection(), tableName);
        int i = 0;
        while (i < primaryKeyFieldList.size()) {
            Field field = primaryKeyFieldList.get(i);
            Object value = field.get(entity);
            ++primaryKeyOffset.value;
            int sqlTypeId = this.primaryKeySqlTypeIdList.get(i);
            sqlContext.setPreStmtValue((PreparedStatement)ppst, primaryKeyOffset.value, sqlTypeId, value);
            ++i;
        }
        List<Method> keyMethodList = this.getPrimaryKeyMethodList(dtsSession.getConnection(), tableName);
        int i2 = 0;
        while (i2 < keyMethodList.size()) {
            Method method = keyMethodList.get(i2);
            OrmPersistenceField persistenceField = method.getAnnotation(OrmPersistenceField.class);
            Object value = method.invoke(entity, new Object[0]);
            ++primaryKeyOffset.value;
            int sqlTypeId = this.keyMethodSqlTypeIdList.get(i2);
            sqlContext.setPreStmtValue((PreparedStatement)ppst, primaryKeyOffset.value, sqlTypeId, value);
            ++i2;
        }
    }

    public void setPrimaryKeyValue(DtsSession dtsSession, SqlPreparedStatement ppst, String tableName, Object entity) throws Exception {
        BcInteger primaryKeyOffset = new BcInteger();
        this.setPrimaryKeyValue(dtsSession, ppst, tableName, primaryKeyOffset, entity);
    }

    public void autoSequence(DtsSession dtsSession, String tableName, Object entity) throws Exception {
        int i = 0;
        while (i < this.getFieldList().size()) {
            Number id;
            long[] sequence;
            Field field = this.getFieldList().get(i);
            OrmPersistenceField persistenceField = field.getAnnotation(OrmPersistenceField.class);
            if (persistenceField != null && (sequence = persistenceField.sequence())[1] > 0L && ((id = (Number)BcReflectUtil.getFieldValue(field.getName(), entity)) == null || id.longValue() <= 0L)) {
                String columnName = OrmPersistenceUtil.toColumnName(this.persistenceEntity, field);
                String sequenceName = MmdUtil.createTableColumnName(tableName, columnName);
                Long newId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, sequenceName);
                if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
                    BcReflectUtil.setFieldValue(field, entity, (Object)newId);
                } else if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
                    BcReflectUtil.setFieldValue(field, entity, (Object)((Number)newId).intValue());
                } else if (field.getType().equals(Short.class) || field.getType().equals(Short.TYPE)) {
                    BcReflectUtil.setFieldValue(field, entity, (Object)((Number)newId).shortValue());
                } else if (field.getType().equals(Byte.class) || field.getType().equals(Byte.TYPE)) {
                    BcReflectUtil.setFieldValue(field, entity, (Object)((Number)newId).byteValue());
                }
            }
            ++i;
        }
    }

    public void setTimeStampFunction(SqlContext sqlContext, SqlUpdateQuery updateQuery) throws Exception {
        String columnName;
        ArrayList<String> timeStampList = new ArrayList<String>();
        int i = 0;
        while (i < this.getFieldList().size()) {
            Field field = this.getFieldList().get(i);
            OrmPersistenceField persistenceField = field.getAnnotation(OrmPersistenceField.class);
            if (persistenceField != null && persistenceField.isTimestamp()) {
                columnName = OrmPersistenceUtil.toColumnName(this.persistenceEntity, field);
                timeStampList.add(columnName);
            }
            ++i;
        }
        i = 0;
        while (i < updateQuery.getSetClauseList().size()) {
            SqlSetClause setClause = updateQuery.getSetClauseList().get(i);
            int j = 0;
            while (j < timeStampList.size()) {
                columnName = (String)timeStampList.get(j);
                if (setClause.columnName.equals(columnName)) {
                    setClause.function = sqlContext.func_clockTimestamp();
                }
                ++j;
            }
            ++i;
        }
    }

    public List<String> cretaeColumnNameList(String prefix) throws Exception {
        String prefix2 = prefix != null ? prefix : "";
        ArrayList<String> columnNameList = new ArrayList<String>();
        int i = 0;
        while (i < this.getFieldList().size()) {
            Field field = this.getFieldList().get(i);
            if (OrmPersistenceUtil.isPersistence(field)) {
                List<String> columnNameList2 = this.cretaeColumnNameList_Field(field, prefix);
                columnNameList.addAll(columnNameList2);
            }
            ++i;
        }
        i = 0;
        while (i < this.getGetterMethodList().size()) {
            Method method = this.getGetterMethodList().get(i);
            OrmPersistenceField getterMethodAnnotation = method.getAnnotation(OrmPersistenceField.class);
            String tmpStr = String.valueOf(prefix2) + getterMethodAnnotation.columnName()[0];
            columnNameList.add(tmpStr);
            ++i;
        }
        return columnNameList;
    }

    public List<String> cretaeColumnNameList_Field(Field field, String prefix) throws Exception {
        ArrayList<String> columnNameList1 = new ArrayList<String>();
        OrmPersistenceField persistenceField = field.getAnnotation(OrmPersistenceField.class);
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            List<String> columnNameList2 = this.cretaeColumnNameList_ArrayField(field);
            columnNameList1.addAll(columnNameList2);
        } else {
            OrmPersistenceEntity persistenceEntity2 = fieldType.getAnnotation(OrmPersistenceEntity.class);
            if (persistenceEntity2 == null) {
                String columnName = OrmPersistenceUtil.toColumnName(this.persistenceEntity, field, prefix);
                columnNameList1.add(columnName);
            } else {
                String prefix2 = null;
                if (persistenceField != null && persistenceField.columnName().length > 0) {
                    prefix2 = persistenceField.columnName()[0];
                }
                OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(fieldType);
                List<String> columnNameList2 = entityContext.cretaeColumnNameList(prefix2);
                columnNameList1.addAll(columnNameList2);
            }
        }
        return columnNameList1;
    }

    public List<String> cretaeColumnNameList_ArrayField(Field arrayField) throws Exception {
        Class componentType = OrmPersistenceUtil.getComponentType(arrayField.getType());
        OrmPersistenceField persistenceField = arrayField.getAnnotation(OrmPersistenceField.class);
        ArrayList<String> columnNameList1 = new ArrayList<String>();
        ArrayList<String> columnNameList2 = new ArrayList<String>();
        if (persistenceField.columnName().length == 1) {
            String columnName = persistenceField.columnName()[0];
            int wcIndex = columnName.indexOf(63);
            String tmpStr = columnName.substring(wcIndex);
            int wcLength = 0;
            int i = 0;
            while (i < tmpStr.length()) {
                if (tmpStr.charAt(i) != '?') break;
                ++wcLength;
                ++i;
            }
            String wcStr = BcStringUtil.fill('?', wcLength);
            int i2 = 0;
            while (i2 < persistenceField.arrayLength()) {
                int num = persistenceField.baseNumber() + i2;
                String numStr = BcStringUtil.fillPrefix(Integer.toString(num), wcLength, '0');
                String convertedColumnName = BcStringUtil.replace((CharSequence)columnName, wcStr, numStr).toString();
                columnNameList2.add(convertedColumnName);
                ++i2;
            }
        } else if (persistenceField.columnName().length > 1) {
            List columnNameList3 = Arrays.asList(persistenceField.columnName());
            columnNameList3 = new ArrayList<String>(columnNameList3);
            columnNameList3 = BcCollectionUtil.toNotEmptyList(columnNameList3);
            columnNameList2.addAll(columnNameList3);
        }
        OrmPersistenceEntity persistenceEntity = componentType.getAnnotation(OrmPersistenceEntity.class);
        if (persistenceEntity == null) {
            columnNameList1.addAll(columnNameList2);
        } else {
            int i = 0;
            while (i < columnNameList2.size()) {
                String columnName2 = (String)columnNameList2.get(i);
                OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(componentType);
                List<String> columnNameList3 = entityContext.cretaeColumnNameList(columnName2);
                columnNameList1.addAll(columnNameList3);
                ++i;
            }
        }
        return columnNameList1;
    }

    public List<Object> createValueList(Object entity, boolean isPpst, List<Integer> sqlTypeList1, List<Integer> sqlTypeList2, BcInteger typeIndex, BcInteger arrayIndex) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        List<Field> fieldList = this.getFieldList();
        int i = 0;
        while (i < fieldList.size()) {
            Field field = fieldList.get(i);
            Object fieldValue = field.get(entity);
            OrmPersistenceField persistenceField = field.getAnnotation(OrmPersistenceField.class);
            OrmPersistenceUtil.addValues(fieldValue, persistenceField, isPpst, sqlTypeList1, sqlTypeList2, typeIndex, valueList, arrayIndex);
            ++i;
        }
        List<Method> methodList = this.getGetterMethodList();
        int i2 = 0;
        while (i2 < methodList.size()) {
            Method method = methodList.get(i2);
            Object methodValue = method.invoke(entity, new Object[0]);
            valueList.add(methodValue);
            sqlTypeList2.add(sqlTypeList1.get(typeIndex.value));
            ++typeIndex.value;
            ++i2;
        }
        return valueList;
    }
}

