/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import com.atilika.kuromoji.ipadic.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.nlp.KuromojiUtil;
import jp.co.extreme.nlp.NlpAbstractNounFinder;
import jp.co.extreme.nlp.NlpElement;
import jp.co.extreme.nlp.NlpModule;
import jp.co.extreme.nlp.NlpNoun;
import jp.co.extreme.nlp.NlpTokenWrap;
import jp.co.extreme.nlp.NlpUtil;
import jp.co.extreme.nlp.NlpWord;
import jp.co.extreme.nlp.OpenNlpUtil;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;

public class NlpNounFinderJA
extends NlpAbstractNounFinder {
    private Tokenizer tokenizer;
    public List<NlpModule> moduleList = new ArrayList<NlpModule>();
    List<TokenNameFinder> tokenNameFinderList = new ArrayList<TokenNameFinder>();

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<NlpNoun> find(String src) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            this.getLogger().warning("src is empty.");
        }
        List tokenList1 = this.tokenizer.tokenize(src);
        List<NlpTokenWrap> tokenWrapList = KuromojiUtil.tokenWrapList(tokenList1);
        KuromojiUtil.check(tokenWrapList);
        ArrayList<NlpElement> elementList1 = new ArrayList<NlpElement>();
        int i = 0;
        while (i < this.moduleList.size()) {
            NlpModule module = this.moduleList.get(i);
            List<NlpElement> elementList = module.find(tokenWrapList);
            elementList1.addAll(elementList);
            ++i;
        }
        List<NlpElement> elementList3 = NlpUtil.organize(elementList1);
        return NlpUtil.toNownList(elementList3, false);
    }

    protected List<NlpElement> find(String[] sentenceArray) throws Exception {
        ArrayList<NlpElement> elementList = new ArrayList<NlpElement>();
        int i = 0;
        while (i < this.tokenNameFinderList.size()) {
            TokenNameFinder tokenNameFinder = this.tokenNameFinderList.get(i);
            this.getLogger().debug("tokenNameFinder=" + tokenNameFinder);
            Span[] spans = tokenNameFinder.find(sentenceArray);
            if (!BcCollectionUtil.isEmpty(spans)) {
                int j = 0;
                while (j < spans.length) {
                    Span span = spans[j];
                    this.getLogger().debug(OpenNlpUtil.createInfo(span, sentenceArray));
                    NlpWord noun = new NlpWord();
                    noun.text = OpenNlpUtil.toString(span, sentenceArray);
                    this.getLogger().warning("TokenNameFinder:name=" + noun.text);
                    noun.key = noun.text.replace(BcUnicode.Unicode.SPACE.string, "");
                    NlpElement nlpElement = NlpUtil.createElement(noun, null);
                    elementList.add(nlpElement);
                    ++j;
                }
            }
            tokenNameFinder.clearAdaptiveData();
            ++i;
        }
        return elementList;
    }

    protected void temp(List<NlpElement> elementList, List<NlpTokenWrap> tokenWrapList) throws Exception {
        int i = 0;
        while (i < elementList.size()) {
            NlpElement nlpElement = elementList.get(i);
            ++i;
        }
    }

    public void addModule(NlpModule nounFinder) throws Exception {
        this.moduleList.add(nounFinder);
    }
}

