/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import com.atilika.kuromoji.ipadic.Token;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.nlp.NlpToken;
import jp.co.extreme.nlp.NlpTokenWrap;

public class KuromojiUtil {
    static List<String> speechLevel1 = new ArrayList<String>();
    static List<String> speechLevel2;
    static List<String> speechLevel2Comma;

    static {
        speechLevel1.add("\u52a9\u52d5\u8a5e");
        speechLevel1.add("\u52a9\u52d5\u8a5e");
        speechLevel2 = new ArrayList<String>();
        speechLevel2.add("\u4ee3\u540d\u8a5e");
        speechLevel2.add("\u526f\u8a5e\u53ef\u80fd");
        speechLevel2.add("\u63a5\u5c3e");
        speechLevel2.add("\u6570");
        speechLevel2Comma = new ArrayList<String>();
        speechLevel2Comma.add("\u53e5\u70b9");
        speechLevel2Comma.add("\u8aad\u70b9");
    }

    private KuromojiUtil() {
    }

    public static List<NlpTokenWrap> tokenWrapList(List<Token> tokenList) throws Exception {
        ArrayList<NlpTokenWrap> tokenWrapList = new ArrayList<NlpTokenWrap>();
        int i = 0;
        while (i < tokenList.size()) {
            Token token = tokenList.get(i);
            NlpToken nlpToken = KuromojiUtil.toNlpToken(token);
            NlpTokenWrap tokenWrap = new NlpTokenWrap();
            tokenWrap.index = i++;
            tokenWrap.token = nlpToken;
            tokenWrapList.add(tokenWrap);
        }
        return tokenWrapList;
    }

    public static void check(List<NlpTokenWrap> tokenWrapList) throws Exception {
        NlpTokenWrap preTokenWrap = null;
        int i = 0;
        while (i < tokenWrapList.size()) {
            NlpTokenWrap tokenWrap = tokenWrapList.get(i);
            NlpToken token = tokenWrap.token;
            if (speechLevel1.contains(token.posLevel1)) {
                ++tokenWrap.posLevel;
            }
            if (speechLevel2.contains(token.posLevel2)) {
                ++tokenWrap.posLevel;
            }
            if (speechLevel2Comma.contains(token.posLevel2)) {
                ++tokenWrap.comma;
            }
            if ("=".equals(token.surface)) {
                ++tokenWrap.usage;
            }
            if (SpeechLevel.\u63a5\u5c3e.name().equals(token.posLevel2) && preTokenWrap != null) {
                ++preTokenWrap.usage;
            }
            preTokenWrap = tokenWrap;
            ++i;
        }
    }

    public static String toTokenizedString(List<NlpTokenWrap> tokenWrapList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tokenWrapList.size()) {
            NlpTokenWrap tokenWrap = tokenWrapList.get(i);
            if (i > 0) {
                sb.append((Object)BcUnicode.Unicode.SPACE);
            }
            sb.append(tokenWrap.token.surface);
            ++i;
        }
        return sb.toString();
    }

    public static NlpToken toNlpToken(Token krmjToken) throws Exception {
        NlpToken nlpToken = new NlpToken();
        nlpToken.baseForm = krmjToken.getBaseForm();
        nlpToken.conjugationForm = krmjToken.getConjugationForm();
        nlpToken.conjugationType = krmjToken.getConjugationType();
        nlpToken.posLevel1 = krmjToken.getPartOfSpeechLevel1();
        nlpToken.posLevel2 = krmjToken.getPartOfSpeechLevel2();
        nlpToken.posLevel3 = krmjToken.getPartOfSpeechLevel3();
        nlpToken.posLevel4 = krmjToken.getPartOfSpeechLevel4();
        nlpToken.pronunciation = krmjToken.getPronunciation();
        nlpToken.reading = krmjToken.getReading();
        nlpToken.surface = krmjToken.getSurface();
        nlpToken.beginIndex = krmjToken.getPosition();
        nlpToken.isKnown = krmjToken.isKnown();
        nlpToken.isUser = krmjToken.isUser();
        return nlpToken;
    }

    public static enum SpeechLevel {
        \u63a5\u5c3e;

    }
}

