/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xupd.client;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import javafx.stage.Window;
import jp.co.extreme.app.common.ApConstants;
import jp.co.extreme.awt.AwtUtil;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.lib.ant.AntUtil;
import jp.co.extreme.module.xupd.common.XupdUtil;
import jp.co.extreme.module.xupd.fx.XupdMonitorPane;
import jp.co.extreme.swing.SwgUtil;
import jp.co.extreme.task.TskAbstractCallable;
import jp.co.extreme.task.Z_TskTaskScheduler;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.w3c.dom.Document;

public class XupdUpdater {
    BcMonitor monitor = new BcMonitor();
    File antFile;
    Document antDom;
    public BcResult result = new BcResult();
    InnerMonitorPane monitorPane;

    public synchronized void doUpdate(BcMonitor parentMonitor) throws Exception {
        if (parentMonitor != null) {
            parentMonitor.lock();
        }
        this.doUpdate_L2();
        if (parentMonitor != null) {
            parentMonitor.unLock();
        }
    }

    protected void doUpdate_L2() throws Exception {
        this.antFile = XupdUtil.getAntFile2();
        byte[] bytes = BcFileUtil.read(this.antFile);
        this.antDom = XupdUtil.createAntDom(bytes, true);
        File destFile = XupdUtil.getAntFile2();
        BcFileUtil.deleteIfExists(destFile);
        BcXmlUtil.output(this.antDom, destFile, true);
        final String progressMessage = AntUtil.getPropertyValue(this.antDom, "progressTitle");
        final String progressTitle = AntUtil.getPropertyValue(this.antDom, "progressMessage");
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XupdUpdater.this.monitorPane = new InnerMonitorPane();
                    XupdUpdater.this.monitorPane.infoLabeld.setText(progressMessage);
                    XupdUpdater.this.monitorPane.show(progressTitle, null);
                }
                catch (Exception ex) {
                    XupdUpdater.this.handleException(ex);
                }
            }
        });
        this.monitor.lock();
        this.monitor.sync();
        if (AwtUtil.isGuiEnabled()) {
            this.monitor.lock();
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    XupdUpdater.this.monitorPane.close();
                    if (XupdUpdater.this.result.hasError()) {
                        String msg = BcMessageCreator.getInstance().createMessage(XupdUpdater.this.result.getErrorList());
                        FxOptionPane.showMessageDialog(msg, BcWords.getInstance().warning, 2);
                    } else {
                        String msg = "\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002";
                        FxOptionPane.showMessageDialog(msg, BcWords.getInstance().information, 1);
                    }
                    XupdUpdater.this.monitor.unLock();
                }
            });
        }
        this.monitor.sync();
    }

    protected void startAntTask() throws Exception {
        BcLogUtil.debug("startAntTask:antFile=" + this.antFile.getPath());
        Project project = new Project();
        project.init();
        ProjectHelper.getProjectHelper().parse(project, this.antFile);
        BuildLogger buildLogger = this.getBuildLogger();
        project.addBuildListener(buildLogger);
        project.executeTarget(project.getDefaultTarget());
        BcLogUtil.debug("Ant task completed.");
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XupdUpdater.this.monitorPane.close();
                }
                catch (Exception ex) {
                    XupdUpdater.this.handleException(ex);
                }
            }
        });
        this.monitor.unLock();
    }

    protected BuildLogger getBuildLogger() {
        DefaultLogger buildLogger = new DefaultLogger();
        buildLogger.setMessageOutputLevel(2);
        InnerOutputStream os = new InnerOutputStream();
        PrintStream printStream = new PrintStream(os);
        buildLogger.setOutputPrintStream(printStream);
        buildLogger.setErrorPrintStream(printStream);
        buildLogger.setEmacsMode(false);
        return buildLogger;
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    class InnerMonitorPane
    extends XupdMonitorPane {
        @Override
        protected void windowOpend() {
            super.windowOpend();
            try {
                InnerUpdateTask updateTask = new InnerUpdateTask();
                Z_TskTaskScheduler.getInstance().startTask(updateTask);
            }
            catch (Exception ex) {
                XupdUpdater.this.handleException(ex);
            }
        }
    }

    class InnerOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            Charset charset = BcConstants.charset;
            final String text = new String(bytes, offset, length, charset);
            BcLogUtil.debug("text=" + text);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((InnerOutputStream)InnerOutputStream.this).XupdUpdater.this.monitorPane.infoLabeld.setText(text);
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(int b) throws IOException {
            byte[] bytes = new byte[]{(byte)b};
            this.write(bytes);
        }
    }

    class InnerUpdateTask
    extends TskAbstractCallable {
        InnerUpdateTask() {
        }

        public Object taskProcess() throws Exception {
            XupdUpdater.this.startAntTask();
            return null;
        }

        @Override
        protected void handleException(final Throwable throwable) {
            super.handleException(throwable);
            BcLogUtil.error(throwable);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String msg = throwable.getMessage();
                        FxOptionPane.showMessageDialog((Window)((InnerUpdateTask)InnerUpdateTask.this).XupdUpdater.this.monitorPane.stage, (Object)msg, BcWords.getInstance().error, 0);
                        System.exit(ApConstants.ExitCode.NG.code);
                    }
                    catch (Exception ex) {
                        InnerUpdateTask.this.handleException(ex);
                    }
                }
            });
        }
    }
}

