/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.server;

import java.sql.Driver;
import java.util.Properties;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsConnectionManagerImpl;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.module.xsys.server.XsysDatasourceUpdater;
import jp.co.extreme.rmi.agent.RmiAgent;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.server.RmiAgentEventHandler;
import jp.co.extreme.rmi.server.RmiServer;
import jp.co.extreme.scf.datasource.ScfDatasourceConfigParser;
import jp.co.extreme.scf.server.ScfAbstractServerModule;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf5.dao.ScfSchemaVersionDAO;
import jp.co.extreme.scf5.model.ScfSchemaVersion;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.context.SqlContext_H2;

public class XsysServerModule
extends ScfAbstractServerModule
implements RmiAgentEventHandler {
    @Override
    public void init() throws Exception {
        this.setupDatasource();
        this.updateSchema();
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            RmiServer rmixServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
            rmixServer.addAgentEventHandler(this);
        }
    }

    protected void setupDatasource() throws Exception {
        String dbPath = ApApplication.getInstance().toReal("${APP}data/main");
        String driverClassName = "org.h2.Driver";
        String jdbcUrl = SqlContext_H2.cretaeUrlFile(dbPath);
        Properties sqlConnProps = new Properties();
        sqlConnProps.setProperty(SqlConstants.DataSourceProperty.user.name(), "xsys_admin");
        sqlConnProps.setProperty(SqlConstants.DataSourceProperty.password.name(), "ex4rhk8x");
        Driver driver = SqlUtil.createDriver(driverClassName);
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        ((DtsConnectionManager)connectionManager).setup(driver, jdbcUrl, sqlConnProps);
        DtsSessionFactory dtsSessionFactory = new DtsSessionFactory("main", connectionManager);
        ScfDatasourceConfigParser.setupLogger(dtsSessionFactory, ApApplication.getInstance().getLogDir());
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(dtsSessionFactory);
    }

    protected void updateSchema() throws Exception {
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        DtsSession dtsSession = dtsSessionFactory.createSession(this);
        try {
            try {
                SqlContext sqlContext = dtsSession.getSqlContext();
                ScfSchemaVersion schemaVersion = null;
                if (sqlContext.existTable(dtsSession.getConnection(), ScfSchemaVersionDAO.getInstance().getTableName())) {
                    schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSession);
                }
                if (schemaVersion == null) {
                    schemaVersion = new ScfSchemaVersion();
                    schemaVersion.versionId = 0;
                }
                if (schemaVersion.versionId > 6) {
                    String msg = "Not suport. schemaVersion=" + schemaVersion.versionId;
                    throw new Exception(msg);
                }
                while (schemaVersion.versionId < 6) {
                    ++schemaVersion.versionId;
                    schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
                    XsysDatasourceUpdater datasourceUpdater = new XsysDatasourceUpdater();
                    datasourceUpdater.update(dtsSession, schemaVersion.versionId, true);
                    schemaVersion.updateEndTimestamp = BcTimeUtil.createCalendar();
                    ScfSchemaVersionDAO.getInstance().putEntity(dtsSession, schemaVersion);
                    dtsSession.commit();
                }
            }
            catch (Exception ex) {
                dtsSession.rollback();
                throw ex;
            }
        }
        finally {
            dtsSession.desturuct();
        }
    }

    @Override
    public void agentAdded(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void agentRemoved(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void firstStatusChecked(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void invokeException(RmiRmoArgument rmixArg, Throwable throwable) throws Exception {
        BcLogUtil.error(throwable);
    }
}

