/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xmmd.fx;

import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xmmd.model.XmmdField;
import jp.co.extreme.sql.SqlType;

public class XmmdFieldTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8631074177425323436L;
    protected String tableName;
    public List<String> filedNameList;
    protected Map<String, XmmdField> fieldMap;
    protected DtsWordManager wordManager;

    public XmmdFieldTableModel(String tableName, List<String> filedNameList, Map<String, XmmdField> fieldMap, DtsWordManager wordManager) throws Exception {
        this.tableName = tableName;
        this.filedNameList = filedNameList;
        this.fieldMap = fieldMap;
        this.wordManager = wordManager;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Class<?> getColumnClass(int columnId) {
        return Object.class;
    }

    @Override
    public int getRowCount() {
        return this.filedNameList.size();
    }

    @Override
    public Object getValueAt(int rowId, int columnId) {
        Object value = null;
        try {
            value = this.getValueAt_L2(rowId, columnId);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            throw new RuntimeException(ex);
        }
        return value;
    }

    public Object getValueAt_L2(int rowId, int columnId) throws Exception {
        String fieldName = this.filedNameList.get(rowId);
        XmmdField xmmdField = this.fieldMap.get(fieldName);
        Object value = null;
        switch (columnId) {
            case 0: {
                value = xmmdField.ordinalPosition;
                break;
            }
            case 1: {
                value = xmmdField.columnName;
                break;
            }
            case 2: {
                SqlType sqlType = SqlType.getById(xmmdField.sqlTypeId);
                if (sqlType != null) {
                    value = sqlType.name();
                    break;
                }
                value = xmmdField.sqlTypeId;
                break;
            }
            case 3: {
                value = xmmdField.dataSize;
                break;
            }
            case 4: {
                value = xmmdField.decimalDigit;
                break;
            }
            case 5: {
                value = BcBooleanUtil.toYN(xmmdField.nullable);
                break;
            }
            case 6: {
                value = XdtsUtil.getLogicalName(this.tableName, xmmdField, this.wordManager);
            }
        }
        return value;
    }
}

