/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xmmd.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xmmd.model.XmmdScreen;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XmmdScreenDAO
extends OrmAbstractDAO<XmmdScreen> {
    private XmmdScreenDAO() {
        super(new XmmdScreen[0]);
        this.setTableName("xmmd_screen");
    }

    public static XmmdScreenDAO getInstance() {
        return SingletonHolder.instance;
    }

    public List<XmmdScreen> getEntityList(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectQuery.setFromClause(this.tableName);
        if (schemaId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + schemaId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(modelName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("model_name " + sqlContext.toCondition_string("=", modelName));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.getOrderByList().add("schema_id");
        selectQuery.getOrderByList().add("model_name");
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public XmmdScreen getByName(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        List<XmmdScreen> profileList = this.getEntityList(dtsSession, schemaId, modelName);
        XmmdScreen profile = null;
        if (profileList.size() > 0) {
            profile = profileList.get(0);
        }
        return profile;
    }

    /* synthetic */ XmmdScreenDAO(XmmdScreenDAO xmmdScreenDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XmmdScreenDAO instance = new XmmdScreenDAO(null);

        private SingletonHolder() {
        }
    }
}

