/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcLockManger;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xfil.common.XfilCaptureUtil;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureCondition;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureParameter;
import jp.co.extreme.module.xfil.server.SnapshotTask;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.module.xfil.server.XfilVideoCaptureHelper;
import jp.co.extreme.task.TskAbstractCallable;

public class XfilVideoCaptureTask
extends TskAbstractCallable {
    public Future future;
    DtsSession dtsSessionMain;
    DtsSession dtsSessionWk;
    XfilUriEntityDAO uriEntityDao;
    boolean initThumbnail = true;
    XfilVideoCaptureHelper videoCaptureHelper = new XfilVideoCaptureHelper();

    @Override
    public void setLogger(BcLogger logger) {
        super.setLogger(logger);
        if (this.videoCaptureHelper != null) {
            this.videoCaptureHelper.setLogger(logger);
        }
    }

    public Object taskProcess() throws Exception {
        BcResult result2 = XfilServerUtil.getInstance().validateCapturingCondition(this.dtsSessionMain);
        long exceptEntityId = -1L;
        while (true) {
            XfilUriEntity uriEntity;
            if ((uriEntity = (XfilUriEntity)this.uriEntityDao.getForThumbnail(this.dtsSessionWk, -1L, exceptEntityId)) == null) {
                Thread.sleep(3000L);
                exceptEntityId = -1L;
                continue;
            }
            XfilUriEntity preEntity = EtcLockManger.getInstance().check(uriEntity, uriEntity.id);
            if (preEntity == null) {
                block9: {
                    try {
                        try {
                            this.proc1(uriEntity);
                        }
                        catch (Exception ex) {
                            this.getLogger().error(ex);
                            EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                        throw throwable;
                    }
                    EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                }
                exceptEntityId = -1L;
            } else {
                exceptEntityId = preEntity.id;
            }
            this.getLogger().info(null);
        }
    }

    public void proc1(XfilUriEntity uriEntity) throws Exception {
        XfilVideoCaptureParameter videoCaptureParameter = null;
        try {
            if (BcStringUtil.isEmpty(uriEntity.videoCaptureParameter)) {
                XfilVideoCaptureCondition videoCaptureCondition = XfilCaptureUtil.createVideoCaptureConditionDefault();
                videoCaptureParameter = XfilCaptureUtil.convert(videoCaptureCondition);
            } else {
                videoCaptureParameter = (XfilVideoCaptureParameter)JacksonUtil.getObjectMapper().readValue(uriEntity.videoCaptureParameter, (TypeReference)new TypeReference<XfilVideoCaptureParameter>(){});
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            XfilVideoCaptureCondition videoCaptureCondition = XfilCaptureUtil.createVideoCaptureConditionDefault();
            videoCaptureParameter = XfilCaptureUtil.convert(videoCaptureCondition);
        }
        File dir = XfilUtil.getThumbnailsDir(uriEntity.id);
        this.videoCaptureHelper.proc1(uriEntity, videoCaptureParameter, dir);
        this.uriEntityDao.putEntity(this.dtsSessionWk, uriEntity);
        this.dtsSessionWk.commit();
    }

    protected void initThumbnail() throws Exception {
        long entityId = -1L;
        long crawlId = -1L;
        List uriEntityList = this.uriEntityDao.getList(this.dtsSessionWk, XfilUriEntityDAO.Mode.id, entityId, -1L, crawlId, null, null, null, -1, false, new long[0]);
        this.getLogger().info("\u30d5\u30a1\u30a4\u30eb\u6570=" + uriEntityList.size());
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
            uriEntity.thumbnailTimestamp = null;
            uriEntity.error2 = null;
            ++i;
        }
        this.getLogger().info("\u6c38\u7d9a\u5316\u4e2d...");
        this.uriEntityDao.putEntityCollection(this.dtsSessionWk, uriEntityList);
        this.dtsSessionWk.commit();
    }

    public void snapshotOrig(XfilUriEntity uriEntity) throws Exception {
        File imputFile = XfilUtil.toFile(uriEntity);
        SnapshotTask snapshotTask = new SnapshotTask();
        URI uri = XfilUtil.toUri(uriEntity);
        File dir = XfilUtil.getThumbnailsDir(uriEntity.id);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future future = executorService.submit(snapshotTask);
        Object res = future.get();
        uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
    }
}

