/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.extreme.app.common.ApApplication;
import jp.co.extreme.app.common.ApConstants;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.module.xfil.common.FfmpegUtil;
import jp.co.extreme.module.xfil.common.FfprobeUtil;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.dao.XfilCrawlDAO;
import jp.co.extreme.module.xfil.dao.XfilCrawlerDAO;
import jp.co.extreme.module.xfil.dao.XfilIndexGroupDAO;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilCrawl;
import jp.co.extreme.module.xfil.model.XfilCrawler;
import jp.co.extreme.module.xfil.model.XfilFileCrawlUnit;
import jp.co.extreme.module.xfil.model.XfilIndexGroup;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureParameter;
import jp.co.extreme.module.xfil.server.XfilDnDProcessingTask;
import jp.co.extreme.module.xfil.server.XfilTagCreateTask;
import jp.co.extreme.module.xfil.server.XfilVideoCaptureTask;
import jp.co.extreme.module.xsys.server.XsysBasicTableCreator;
import jp.co.extreme.module.xsys.server.XsysDatasourceUpdater;
import jp.co.extreme.nlp.NlpFinderBuilder;
import jp.co.extreme.nlp.NlpNounFinderEN;
import jp.co.extreme.nlp.NlpNounFinderJA;
import jp.co.extreme.nlp.NlpUtil;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.scf5.dao.ScfAbstractIntPropertyDAO;
import jp.co.extreme.scf5.dao.ScfSchemaVersionDAO;
import jp.co.extreme.scf5.dao.ZScfPropertyDAOManager;
import jp.co.extreme.scf5.model.ScfSchemaVersion;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.task.TskAbstractCallable;
import jp.co.extreme.task.TskCallableUnit;
import jp.co.extreme.task.TskTaskManager;

public class XfilServerUtil
extends BcLoggableObject {
    int taskCnt = 1;
    List<XfilDnDProcessingTask> dnDProcessingTaskList = new ArrayList<XfilDnDProcessingTask>();
    List<XfilVideoCaptureTask> videoCaptureTaskList = new ArrayList<XfilVideoCaptureTask>();
    List<XfilTagCreateTask> tagCreateTaskList = new ArrayList<XfilTagCreateTask>();
    public ConcurrentLinkedQueue<XfilFileCrawlUnit> crawlQueue = new ConcurrentLinkedQueue();
    protected NlpNounFinderJA nounFinderJA;
    protected NlpNounFinderEN nounFinderEN;
    boolean dNdTaskStarted;
    private DtsSessionFactory dtsSessionFactoryWk;

    private XfilServerUtil() {
    }

    public static XfilServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public NlpNounFinderJA getNounFinderJA() throws Exception {
        if (this.nounFinderJA == null) {
            this.nounFinderJA = this.createNounFinderJA();
        }
        return this.nounFinderJA;
    }

    public NlpNounFinderJA createNounFinderJA() throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        File dir = new File(ApApplication.getInstance().getRootDirectry(), "dictionary/ja/person_name");
        this.getLogger().debug("dir=" + dir.getPath());
        if (dir.exists()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.getLogger().debug("file=" + file.getPath());
                fileList.add(file);
                ++n2;
            }
        }
        StringBuilder sb = NlpUtil.temp(fileList);
        ByteArrayInputStream bais = null;
        if (!BcStringUtil.isEmpty(sb)) {
            bais = new ByteArrayInputStream(sb.toString().getBytes(BcConstants.charset));
        }
        NlpNounFinderJA nounFinder = NlpFinderBuilder.build_jp(bais);
        return nounFinder;
    }

    public NlpNounFinderEN getNounFinderEN() throws Exception {
        if (this.nounFinderEN == null) {
            this.nounFinderEN = this.createNounFinderEN();
        }
        return this.nounFinderEN;
    }

    public NlpNounFinderEN createNounFinderEN() throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        File dir = new File(ApApplication.getInstance().getRootDirectry(), "dictionary/en/person_name");
        this.getLogger().debug("dir=" + dir.getPath());
        if (dir.exists()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.getLogger().debug("file=" + file.getPath());
                fileList.add(file);
                ++n2;
            }
        }
        StringBuilder sb = NlpUtil.temp(fileList);
        ByteArrayInputStream bais = null;
        if (!BcStringUtil.isEmpty(sb)) {
            bais = new ByteArrayInputStream(sb.toString().getBytes(BcConstants.charset));
        }
        NlpNounFinderEN nounFinder = NlpFinderBuilder.build_en(bais);
        return nounFinder;
    }

    public void startService1() throws Exception {
        TskAbstractCallable task;
        Throwable throwable = null;
        Object var2_4 = null;
        try (DtsSession dtsSessionWk = this.createDtsSession(this, -1L);){
            int cnt = XfilCrawlDAO.getInstance().updateCanceled(dtsSessionWk);
            this.getLogger().debug("Canceled crawl count=" + cnt);
            dtsSessionWk.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        int i = 0;
        while (i < this.taskCnt) {
            task = new XfilVideoCaptureTask();
            ((XfilVideoCaptureTask)task).setLogger(this.createLogger("VideoCaptureTask"));
            ((XfilVideoCaptureTask)task).dtsSessionMain = dtsSessionFactoryMain.createSession(this);
            ((XfilVideoCaptureTask)task).dtsSessionMain.getConnection().setLendingTimeout(-1L);
            ((XfilVideoCaptureTask)task).dtsSessionWk = this.createDtsSession(this, -1L);
            ((XfilVideoCaptureTask)task).uriEntityDao = this.getUriEntityDAO();
            task.setName("Video Capture Task");
            this.videoCaptureTaskList.add((XfilVideoCaptureTask)task);
            ++i;
        }
        i = 0;
        while (i < this.taskCnt) {
            task = new XfilTagCreateTask();
            task.setLogger(this.createLogger("TagCreateTask"));
            ((XfilTagCreateTask)task).dtsSessionWk = this.createDtsSession(this, -1L);
            ((XfilTagCreateTask)task).uriEntityDao = this.getUriEntityDAO();
            task.setName("Tag Create Task");
            this.tagCreateTaskList.add((XfilTagCreateTask)task);
            ++i;
        }
        this.startTask1();
    }

    protected void startTask1() throws Exception {
        TskCallableUnit callableUnit;
        ExecutorService executorService;
        TskAbstractCallable task;
        int i = 0;
        while (i < this.videoCaptureTaskList.size()) {
            task = this.videoCaptureTaskList.get(i);
            if (((XfilVideoCaptureTask)task).future != null && ((XfilVideoCaptureTask)task).future.isDone()) {
                this.getLogger().debug(String.valueOf(task.getClass().getSimpleName()) + " is done.");
            }
            executorService = Executors.newCachedThreadPool();
            ((XfilVideoCaptureTask)task).future = executorService.submit(task);
            executorService.shutdown();
            callableUnit = new TskCallableUnit(task, ((XfilVideoCaptureTask)task).future);
            TskTaskManager.getInstance().addCallableUnit(callableUnit);
            ++i;
        }
        i = 0;
        while (i < this.tagCreateTaskList.size()) {
            task = this.tagCreateTaskList.get(i);
            if (((XfilTagCreateTask)task).future != null && ((XfilTagCreateTask)task).future.isDone()) {
                this.getLogger().debug(String.valueOf(task.getClass().getSimpleName()) + " is done.");
            }
            executorService = Executors.newCachedThreadPool();
            ((XfilTagCreateTask)task).future = executorService.submit(task);
            executorService.shutdown();
            callableUnit = new TskCallableUnit(task, ((XfilTagCreateTask)task).future);
            TskTaskManager.getInstance().addCallableUnit(callableUnit);
            ++i;
        }
    }

    public void startService2() throws Exception {
        XfilDnDProcessingTask task;
        if (this.dNdTaskStarted) {
            return;
        }
        this.dNdTaskStarted = true;
        int i = 0;
        while (i < this.taskCnt) {
            task = new XfilDnDProcessingTask();
            task.setLogger(this.createLogger("FileCrawlTask"));
            task.dtsSessionWk = this.createDtsSession(this, -1L);
            task.uriEntityDao = this.getUriEntityDAO();
            task.setName("D&D Processing Task");
            this.dnDProcessingTaskList.add(task);
            ++i;
        }
        i = 0;
        while (i < this.dnDProcessingTaskList.size()) {
            task = this.dnDProcessingTaskList.get(i);
            if (task.future != null && !task.future.isDone()) {
                this.getLogger().debug(String.valueOf(task.getClass().getSimpleName()) + " is running.");
            } else {
                ExecutorService executorService = Executors.newCachedThreadPool();
                task.future = executorService.submit(task);
                executorService.shutdown();
            }
            ++i;
        }
    }

    public BcLogger createLogger(String name) throws Exception {
        String loggerName = name;
        String fileName = String.valueOf(loggerName) + ".log";
        File logFile = new File(ApApplication.getInstance().getLogDir(), fileName);
        BcLogger logger = BcLogUtil.createLogger(loggerName, false, BcLogConstants.LogLevel.INFO, true, logFile);
        return logger;
    }

    public BcResult deleteIndexGroup(DtsSession dtsSessionWk, XfilIndexGroup indexGroup) throws Exception {
        BcResult result = new BcResult();
        int cnt = XfilIndexGroupDAO.getInstance().deleteEntity(dtsSessionWk, indexGroup);
        if (cnt > 0) {
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            long crawlId = -1L;
            List uriEntityList = uriEntityDAO.getList(dtsSessionWk, XfilUriEntityDAO.Mode.id, -1L, indexGroup.id, crawlId, null, null, null, -1, false, new long[0]);
            this.getLogger().info("deleteIndexGroup:URI\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u6570=" + uriEntityList.size());
            int i = 0;
            while (i < uriEntityList.size()) {
                XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
                try {
                    XfilUtil.deleteTthumbnails(uriEntity);
                }
                catch (Exception ex) {
                    this.getLogger().equals(ex);
                }
                ++i;
            }
            int deleteCnt = uriEntityDAO.deleteByIndexGroupId(dtsSessionWk, indexGroup.id);
            this.getLogger().info("deleteCnt=" + deleteCnt);
        } else {
            result.addError(BcWords.getInstance().Target_object_does_not_exist);
        }
        return result;
    }

    public BcResult deleteCrawler(DtsSession dtsSessionWk, long indexGroupId, XfilCrawler crawler) throws Exception {
        BcResult result = new BcResult();
        int cnt = XfilCrawlerDAO.getInstance().deleteEntity(dtsSessionWk, crawler);
        return result;
    }

    public void setSummary(DtsSession dtsSession, XfilCrawl crawl) throws Exception {
        XfilUriEntityDAO uriEntitydao = this.getUriEntityDAO();
        List uriEntityList = uriEntitydao.getList(dtsSession, XfilUriEntityDAO.Mode.id, -1L, crawl.id, -1L, null, null, null, -1, false, new long[0]);
        crawl.directoryCount = 0L;
        crawl.fileCount = 0L;
        crawl.missingCount = 0L;
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
            if (uriEntity.entityType == XfilConstants.FileType.directory.id) {
                ++crawl.directoryCount;
            } else {
                ++crawl.fileCount;
            }
            if (uriEntity.missingTimestamp != null) {
                ++crawl.missingCount;
            }
            ++i;
        }
        this.getLogger().debug("crawl.id=" + crawl.id + " directoryCount=" + crawl.directoryCount + " fileCount=" + crawl.missingCount + " fileCount=" + crawl.missingCount);
    }

    public synchronized DtsSession createDtsSession(Object owner, long lendingTimeout) throws Exception {
        DtsSession dtsSessionWk = this.createDtsSession(owner);
        dtsSessionWk.getConnection().setLendingTimeout(lendingTimeout);
        return dtsSessionWk;
    }

    public synchronized DtsSession createDtsSession(Object owner) throws Exception {
        DtsSession dtsSessionWk;
        block12: {
            dtsSessionWk = null;
            if (this.dtsSessionFactoryWk == null) {
                DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
                Throwable throwable = null;
                Object var5_7 = null;
                try (DtsSession dtsSessionMain = dtsSessionFactoryMain.createSession(dtsSessionFactoryMain);){
                    dtsSessionWk = this.createDtsSession_L2(dtsSessionMain, owner);
                    break block12;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            dtsSessionWk = this.dtsSessionFactoryWk.createSession(owner);
        }
        return dtsSessionWk;
    }

    protected synchronized DtsSession createDtsSession_L2(DtsSession dtsSessionMain, Object owner) throws Exception {
        ScfSchemaVersion schemaVersion;
        DtsSessionFactory dtsSessionFactoryMain = dtsSessionMain.getSessionFactory();
        DtsSessionFactory dtsSessionFactoryWk2 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, 1, true);
        dtsSessionFactoryWk2.mmdFieldMap = dtsSessionFactoryMain.mmdFieldMap;
        dtsSessionFactoryWk2.wordManager = dtsSessionFactoryMain.wordManager;
        this.dtsSessionFactoryWk = dtsSessionFactoryWk2;
        DtsSession dtsSessionWk = this.dtsSessionFactoryWk.createSession(owner);
        SqlContext sqlContextWk = dtsSessionWk.getSqlContext();
        if (!sqlContextWk.existTable(dtsSessionWk.getConnection(), OrmSequenceDAO.getInstance().getTableName())) {
            XsysBasicTableCreator basicTableCreator = new XsysBasicTableCreator();
            basicTableCreator.update(dtsSessionWk, 1);
            ScfSchemaVersion schemaVersion2 = new ScfSchemaVersion();
            schemaVersion2.versionId = 3;
            schemaVersion2.updateEndTimestamp = schemaVersion2.updateStartTimestamp = BcTimeUtil.createCalendar();
            ScfSchemaVersionDAO.getInstance().putEntity(dtsSessionWk, schemaVersion2);
            dtsSessionWk.commit();
        }
        if ((schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSessionWk)) == null) {
            this.getLogger().debug("schemaVersion is null.");
            schemaVersion = new ScfSchemaVersion();
            schemaVersion.versionId = 4;
            schemaVersion.updateEndTimestamp = schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
            ScfSchemaVersionDAO.getInstance().putEntity(dtsSessionWk, schemaVersion);
            String query = "ALTER TABLE frwk_sequence_number ALTER COLUMN sequence_name VARCHAR(255)";
            this.getLogger().debug("query=" + query);
            int cnt = SqlUtil.executeUpdate(dtsSessionWk.getConnection(), query);
            query = "CREATE TABLE xfil____________________ (dumy VARCHAR(1))";
            cnt = SqlUtil.executeUpdate(dtsSessionWk.getConnection(), query);
            dtsSessionWk.commit();
        } else {
            this.getLogger().debug("#1:schemaVersion=" + schemaVersion.versionId);
        }
        while (schemaVersion.versionId < 6) {
            ++schemaVersion.versionId;
            this.getLogger().debug("#2:schemaVersion=" + schemaVersion.versionId);
            schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
            XsysDatasourceUpdater datasourceUpdater = new XsysDatasourceUpdater();
            datasourceUpdater.update(dtsSessionWk, schemaVersion.versionId, false);
            schemaVersion.updateEndTimestamp = BcTimeUtil.createCalendar();
            ScfSchemaVersionDAO.getInstance().putEntity(dtsSessionWk, schemaVersion);
            dtsSessionWk.commit();
        }
        return dtsSessionWk;
    }

    public XfilUriEntityDAO getUriEntityDAO() {
        XfilUriEntityDAO uriEntitydao = XfilUriEntityDAO.getInstance(XfilConstants.TableName.xfil_entity.name());
        return uriEntitydao;
    }

    public BcResult validateCapturingCondition(XfilVideoCaptureParameter videoCaptureParam) throws Exception {
        BcResult result = new BcResult();
        if (videoCaptureParam.interval <= 0L) {
            result.addError("\u30ad\u30e3\u30d7\u30c1\u30e3\u9593\u9694\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (videoCaptureParam.headMargin < 0L) {
            result.addError("\u5148\u982d\u30de\u30fc\u30b8\u30f3\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (videoCaptureParam.tailMargin < 0L) {
            result.addError("\u672b\u5c3e\u30de\u30fc\u30b8\u30f3\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (videoCaptureParam.capturingCountMax <= 0) {
            result.addError("\u6700\u5927\u30ad\u30e3\u30d7\u30c1\u30e3\u6570\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        return result;
    }

    public BcResult validateCapturingCondition(DtsSession dtsSessionMain) throws Exception {
        BcResult result;
        block11: {
            int ret;
            File file;
            String filePath;
            String value;
            ScfAbstractIntPropertyDAO propertyDAO2;
            block10: {
                result = new BcResult();
                propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
                value = propertyDAO2.getValue(dtsSessionMain, XdtsConstants.Property.ffprobeFilePath.id);
                if (!BcStringUtil.isEmpty(value)) {
                    try {
                        filePath = ApApplication.getInstance().toReal(value);
                        filePath = BcFileUtil.toOsPath(filePath);
                        file = new File(filePath);
                        if (!file.exists()) break block10;
                        FfprobeUtil.ffprobePath = filePath;
                        ret = FfprobeUtil.checkVersion();
                        if (ret != ApConstants.ExitCode.OK.code) {
                            result.addError("FFprobe \u306e\u30d1\u30b9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error(ex);
                        result.addError("FFprobe \u306e\u30d1\u30b9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                    }
                } else {
                    result.addError("FFprobe \u306e\u30d1\u30b9\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002");
                }
            }
            if (!BcStringUtil.isEmpty(value = (propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name())).getValue(dtsSessionMain, XdtsConstants.Property.ffmpegFilePath.id))) {
                try {
                    filePath = ApApplication.getInstance().toReal(value);
                    filePath = BcFileUtil.toOsPath(filePath);
                    file = new File(filePath);
                    if (!file.exists()) break block11;
                    FfmpegUtil.ffmpegPath = filePath;
                    ret = FfmpegUtil.checkVersion();
                    if (ret != ApConstants.ExitCode.OK.code) {
                        result.addError("FFprobe \u306e\u30d1\u30b9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                    }
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                    result.addError("FFmpeg \u306e\u30d1\u30b9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                }
            } else {
                result.addError("FFmpeg \u306e\u30d1\u30b9\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002");
            }
        }
        return result;
    }

    public XfilUriEntity fileNotExists(DtsSession dtsSessionWk, XfilUriEntityDAO uriEntityDao, XfilUriEntity uriEntity1) throws Exception {
        List uriEntityList = uriEntityDao.getListByPath(dtsSessionWk, uriEntity1.indexGroupId, uriEntity1.directory, uriEntity1.name, false);
        if (!BcCollectionUtil.isEmpty(uriEntityList)) {
            XfilUriEntity uriEntity2 = (XfilUriEntity)BcCollectionUtil.getFirst(uriEntityList);
            if (uriEntity2.missingTimestamp == null) {
                uriEntity2.missingTimestamp = BcTimeUtil.createCalendar();
                uriEntityDao.putEntity(dtsSessionWk, uriEntity2);
                return uriEntity2;
            }
        }
        return null;
    }

    public boolean checkFileExists(XfilUriEntity uriEntity) throws Exception {
        File file = XfilUtil.toFile(uriEntity);
        boolean fileExists = Files.exists(file.toPath(), new LinkOption[0]);
        if (!fileExists) {
            this.getLogger().info("File missing. path=" + file.getPath());
            if (uriEntity.missingTimestamp == null) {
                uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
            }
        }
        return fileExists;
    }

    /* synthetic */ XfilServerUtil(XfilServerUtil xfilServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final XfilServerUtil instance = new XfilServerUtil(null);

        private SingletonHolder() {
        }
    }
}

