/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.layout.FxTitledPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.fx.XdtsDatasourcePane;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.stub.XdtsProfileStub;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilFilePane;
import jp.co.extreme.module.xfil.fx.XfilFxHelper;
import jp.co.extreme.scf5.model.ZScfIntProperties;
import jp.co.extreme.scf5.stub.ScfPropertyStub;

public class XfilSettingPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    XdtsDatasourcePane datasourcePane = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.editSimple);
    XfilFilePane ffprobePane = new XfilFilePane();
    XfilFilePane ffmpegPane = new XfilFilePane();
    FxButton completionButton = FxUtil.createCompletionButton();
    FxButton cancelButton = FxUtil.createCancelButton();
    XdtsProfile profile;
    Stage stage;

    public XfilSettingPane() throws Exception {
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        FxTitledPane titledPane1 = new FxTitledPane();
        titledPane1.setTitle("datasource");
        titledPane1.setIconNode((Node)FxImageHelper.createImageView_icon("db_64x64.png"));
        titledPane1.setContentNode((Node)this.datasourcePane);
        titledPane1.setPrefSize(this.datasourcePane.getPrefWidth() + 20.0, this.datasourcePane.getPrefHeight() + 20.0);
        FxNodeUnit controlUnit = new FxNodeUnit(null, new Node[]{titledPane1});
        this.centerPane.addNodeUnit(controlUnit);
        FxTitledPane titledPane2 = new FxTitledPane();
        titledPane2.setTitle("FFprobe");
        titledPane2.setContentNode((Node)this.ffprobePane);
        titledPane2.setPrefSize(920.0, 80.0);
        controlUnit = new FxNodeUnit(null, new Node[]{titledPane2});
        this.centerPane.addNodeUnit(controlUnit);
        FxTitledPane titledPane3 = new FxTitledPane();
        titledPane3.setTitle("FFmpeg");
        titledPane3.setContentNode((Node)this.ffmpegPane);
        titledPane3.setPrefSize(920.0, 80.0);
        controlUnit = new FxNodeUnit(null, new Node[]{titledPane3});
        this.centerPane.addNodeUnit(controlUnit);
        this.centerPane.rowSpace = 12.0;
        this.setCenter((Node)this.centerPane);
        this.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.datasourcePane.storeData(this.profile);
            XdtsProfileStub.getInstance().putProfile(this.profile);
            ZScfIntProperties intProps = new ZScfIntProperties();
            intProps.put((Integer)XdtsConstants.Property.ffprobeFilePath.id, this.ffprobePane.filePathField.getText());
            intProps.put((Integer)XdtsConstants.Property.ffmpegFilePath.id, this.ffmpegPane.filePathField.getText());
            ScfPropertyStub.getInstance().putProperties(XdtsConstants.TableName.xdts_property.name(), intProps);
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
        XfilFxHelper.getInstance().remove(((Object)((Object)this)).getClass(), new Object[0]);
    }

    public void show() throws Exception {
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(980.0);
        this.stage.setHeight(500.0);
        this.stage.setResizable(false);
        this.stage.setTitle(XfilWords.getInstance().Setting.toPlain());
        this.stage.getIcons().add((Object)FxImageHelper.getImage("gear_64x64.png"));
        this.stage.show();
        this.setupData();
    }

    protected void setupData() throws Exception {
        this.profile = XdtsProfileStub.getInstance().getProfile(1);
        if (this.profile == null) {
            this.profile = new XdtsProfile();
            this.profile.setDataId(1);
        }
        this.datasourcePane.setData(this.profile);
        ZScfIntProperties intProps = ScfPropertyStub.getInstance().getProperties(XdtsConstants.TableName.xdts_property.name());
        String propValue = intProps.get(XdtsConstants.Property.ffprobeFilePath.id);
        this.ffprobePane.filePathField.setText(propValue);
        propValue = intProps.get(XdtsConstants.Property.ffmpegFilePath.id);
        this.ffmpegPane.filePathField.setText(propValue);
    }
}

