/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.layout.FxTitledPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxDragAndDropHelper;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.common.XfilCaptureUtil;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilConditionSet;
import jp.co.extreme.module.xfil.fx.XfilVideoCaptureConditionPane;
import jp.co.extreme.module.xfil.model.XfilAnalysisCondition;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureCondition;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureParameter;
import jp.co.extreme.module.xfil.stub.XfilFileCrawlStub;

public class XfilFileCrawlDnDPane
extends FxDecoratePane {
    FxBorderPane borderPane1 = new FxBorderPane();
    XfilConditionSet conditionSet = new XfilConditionSet();
    FxFlowPane indexGroupPane = new FxFlowPane(11);
    XfilVideoCaptureConditionPane videoCaptureConditionPane = new XfilVideoCaptureConditionPane();
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextArea filePathTextArea = new FxTextArea();
    FileChooser fileChooser = new FileChooser();
    FxCheckBox autoCheckBox;
    FxButton executeButton;
    FxButton closeButton;
    Stage stage;

    public XfilFileCrawlDnDPane() throws Exception {
        this.autoCheckBox = new FxCheckBox(BcWords.getInstance().auto);
        this.executeButton = FxUtil.createExecuteButton();
        this.closeButton = FxUtil.createCloseButton();
        this.conditionSet.initIndexGroupUnit(false, true);
        this.indexGroupPane.addNodeUnit(this.conditionSet.indexGroupUnit);
        this.indexGroupPane.addNodeUnit(this.conditionSet.overWrirteUnit);
        this.indexGroupPane.addNodeUnit(this.conditionSet.fileExtentionUnit);
        this.indexGroupPane.setPrefHeight(92.0);
        this.borderPane1.setTop((Node)this.indexGroupPane);
        FxTitledPane titledPane1 = new FxTitledPane();
        titledPane1.setContentNode((Node)this.videoCaptureConditionPane);
        titledPane1.setTitle(XfilWords.getInstance().videoCaptureCondition.toPlain());
        titledPane1.setPrefHeight(this.videoCaptureConditionPane.getPrefHeight());
        this.borderPane1.setCenter((Node)titledPane1);
        this.setTop((Node)this.borderPane1);
        this.filePathTextArea.setPrefColumnCount(120);
        FxTitledPane titledPane2 = new FxTitledPane();
        titledPane2.setContentNode((Node)this.filePathTextArea);
        titledPane2.setTitle(XfilWords.getInstance().dragAndDropArea.toPlain());
        titledPane2.setPrefSize(800.0, 260.0);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)titledPane2, new Node[0]);
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        this.getControlPane().addControl((Node)this.autoCheckBox);
        this.executeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.executeButton);
        this.closeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.closeButton);
        this.autoCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CheckBox vheckBox = (CheckBox)event.getSource();
                XfilFileCrawlDnDPane.this.executeButton.setDisable(vheckBox.isSelected());
                if (vheckBox.isSelected()) {
                    try {
                        XfilFileCrawlDnDPane.this.executeButtonAcction();
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            }
        });
        InnerDragAndDropHelper dragAndDropHelper = new InnerDragAndDropHelper();
        dragAndDropHelper.setup((Node)this.filePathTextArea);
        this.setPadding(new Insets(8.0));
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            this.executeButtonAcction();
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    protected void executeButtonAcction() throws Exception {
        XfilAnalysisCondition condition = this.conditionSet.getCondition();
        String tmpStr = this.filePathTextArea.getText();
        this.filePathTextArea.clear();
        this.proc2(condition.indexGroupId, condition.overWrirte, condition.fileExtention, tmpStr);
    }

    protected void proc2(long indexGroupId, boolean overWrirte, String fileExtention, String filePathLines) throws Exception {
        ValidationTask validationTask = new ValidationTask();
        validationTask.indexGroupId = indexGroupId;
        validationTask.overWrirte = overWrirte;
        validationTask.fileExtention = fileExtention;
        validationTask.filePathLines = filePathLines;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future future = executorService.submit(validationTask);
    }

    protected void proc3(long indexGroupId, boolean overWrirte, String fileExtention, String filePathLines) throws Exception {
        List<String> lineList = BcStringUtil.lineSeparete(filePathLines);
        ArrayList<File> fileList = new ArrayList<File>();
        int i = 0;
        while (i < lineList.size()) {
            String line = lineList.get(i);
            ArrayList<String> filePathList = new ArrayList<String>();
            filePathList.add(line);
            int j = 0;
            while (j < filePathList.size()) {
                String filePath = (String)filePathList.get(j);
                File file = new File(filePath);
                fileList.add(file);
                ++j;
            }
            ++i;
        }
        this.proc4(indexGroupId, fileList, overWrirte, fileExtention);
    }

    protected void proc4(long indexGroupId, List<File> fileList, boolean overWrirte, String fileExtention) throws Exception {
        List<XfilUriEntity> uriEntityList = XfilUtil.createUriEntityList(fileList, false);
        for (XfilUriEntity uriEntity : uriEntityList) {
            uriEntity.indexGroupId = indexGroupId;
        }
        XfilVideoCaptureCondition videoCaptureCondition = this.videoCaptureConditionPane.captureConditionSet.getCondition();
        XfilVideoCaptureParameter videoCaptureParameter = XfilCaptureUtil.convert(videoCaptureCondition);
        XfilFileCrawlStub.getInstance().fileCrawl1(uriEntityList, overWrirte, fileExtention, videoCaptureParameter);
    }

    public void close() {
        this.stage.close();
    }

    public void show(File file) throws Exception {
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setResizable(false);
        this.stage.setTitle(String.valueOf(BcWords.getInstance().dragAndDrop_abbreviation) + " " + XfilWords.getInstance().fileCrawl.toPlain());
        FxImageHelper.setStageIcon(this.stage);
        FxUtil.setWindowLocation((Window)this.stage, 100.0, 100.0, 860.0, 650.0);
        this.stage.show();
    }

    public String toFilesStr(List<File> fileList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < fileList.size()) {
            File file = fileList.get(i);
            if (i > 0) {
                sb.append(BcStringUtil.lineSeparator);
            }
            sb.append(file.getPath());
            ++i;
        }
        return sb.toString();
    }

    class InnerDragAndDropHelper
    extends FxDragAndDropHelper {
        InnerDragAndDropHelper() {
        }

        @Override
        protected void cathFileList(List<File> fileList) {
            try {
                String tmpStr = BcStringUtil.toNotNull(BcStringUtil.trim(XfilFileCrawlDnDPane.this.filePathTextArea.getText()));
                StringBuilder sb = new StringBuilder(tmpStr);
                if (!BcStringUtil.isEmpty(sb)) {
                    sb.append(BcStringUtil.lineSeparator);
                }
                sb.append(XfilFileCrawlDnDPane.this.toFilesStr(fileList));
                XfilFileCrawlDnDPane.this.filePathTextArea.setText(sb.toString());
                if (XfilFileCrawlDnDPane.this.autoCheckBox.isSelected()) {
                    XfilFileCrawlDnDPane.this.executeButtonAcction();
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public class ValidationTask
    implements Callable {
        long indexGroupId;
        boolean overWrirte;
        String fileExtention;
        String filePathLines;

        public final Object call() throws Exception {
            try {
                XfilFileCrawlDnDPane.this.proc3(this.indexGroupId, this.overWrirte, this.fileExtention, this.filePathLines);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            return null;
        }
    }
}

