/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.common.XfilCaptureUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilCrawlerHeaderane;
import jp.co.extreme.module.xfil.fx.XfilFxHelper;
import jp.co.extreme.module.xfil.fx.XfilVideoCaptureConditionPane;
import jp.co.extreme.module.xfil.model.XfilCrawler;
import jp.co.extreme.module.xfil.model.XfilVideoCaptureCondition;
import jp.co.extreme.module.xfil.stub.XfilFileCrawlerStub;
import jp.co.extreme.module.xsys.validation.XsysValidator;

public class XfilCrawlerPane
extends FxDecoratePane {
    XfilCrawlerHeaderane crawlerHeaderane = new XfilCrawlerHeaderane();
    FxTabPane tabPane = new FxTabPane();
    XfilVideoCaptureConditionPane videoCaptureConditionPane = new XfilVideoCaptureConditionPane();
    FxButton completionButton = FxUtil.createCompletionButton();
    FxButton cancelButton = FxUtil.createCancelButton();
    XfilCrawler crawler;
    Stage stage;

    public XfilCrawlerPane() throws Exception {
        this.setTop((Node)this.crawlerHeaderane);
        this.tabPane.setSide(Side.TOP);
        Tab tab = new Tab();
        tab.setText(XfilWords.getInstance().videoCaptureCondition.toPlain());
        tab.setContent((Node)this.videoCaptureConditionPane);
        tab.setClosable(false);
        this.tabPane.getTabs().add((Object)tab);
        this.setCenter((Node)this.tabPane);
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setData(XfilCrawler crawler) throws Exception {
        this.crawler = crawler;
        this.crawlerHeaderane.setData(crawler);
        XfilVideoCaptureCondition videoCaptureCondition = XfilCaptureUtil.convVideoCaptureCondition(crawler);
        this.videoCaptureConditionPane.captureConditionSet.setCondition(videoCaptureCondition);
    }

    protected void storeData(XfilCrawler crawler) throws Exception {
        this.crawlerHeaderane.storeData(crawler);
        XfilVideoCaptureCondition videoCaptureCondition = this.videoCaptureConditionPane.captureConditionSet.getCondition();
        crawler.vcIntervalSec = videoCaptureCondition.intervalSec;
        crawler.vcHeadMarginSec = videoCaptureCondition.headMarginSec;
        crawler.vcTailMarginSec = videoCaptureCondition.tailMarginSec;
        crawler.vcCapturingCountMax = videoCaptureCondition.capturingCountMax;
        crawler.vcIntervalSec = videoCaptureCondition.intervalSec;
        crawler.vcCapturingWidth = videoCaptureCondition.capturingWidth;
        crawler.vcCapturingHeight = videoCaptureCondition.capturingHeight;
        crawler.vcElapsedTime = videoCaptureCondition.elapsedTime;
        crawler.vcElapsedTimeHorizontalPositionId = videoCaptureCondition.elapsedTimeHorizontalPositionId;
        crawler.vcElapsedTimeVerticalPositionId = videoCaptureCondition.elapsedTimeVerticalPositionId;
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData(this.crawler);
            XsysValidator validator = XsysValidator.getInstance();
            BcResult result1 = validator.validateForGui(this.crawler);
            if (result1.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            XfilFileCrawlerStub.getInstance().put(this.crawler);
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
        XfilFxHelper.getInstance().remove(((Object)((Object)this)).getClass(), this.crawler.id);
    }

    public void show(long entityId) throws Exception {
        XfilCrawler crawler = null;
        crawler = entityId > 0L ? (XfilCrawler)XfilFileCrawlerStub.getInstance().get(entityId) : XfilCaptureUtil.createCrawlerDefault();
        this.setData(crawler);
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(920.0);
        this.stage.setHeight(820.0);
        this.stage.setResizable(false);
        this.stage.setTitle(String.valueOf(XfilWords.getInstance().crawler) + " ID=" + entityId);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }
}

