/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.swg;

import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.sql.SqlConstants;

public class XdtsImageUtil {
    private XdtsImageUtil() throws Exception {
    }

    public static Image getProductImage(SqlConstants.DatabaseProduct databaseProduct) throws Exception {
        String fileName = null;
        switch (databaseProduct) {
            case H2: {
                fileName = "h2_32x32.png";
                break;
            }
            case HSQLDB: {
                fileName = "hsqldb_128x49.png";
                break;
            }
            case Derby: {
                fileName = "derby_50x50.png";
                break;
            }
            case PostgreSQL: {
                fileName = "postgre_sql_102x102.png";
                break;
            }
            case MySQL: {
                fileName = "my_sql_64x64.png";
                break;
            }
            case Oracle: {
                fileName = "oracle_102x102.png";
                break;
            }
            case DB2: {
                fileName = "db2_48x48.png";
                break;
            }
            case SQLServer: {
                fileName = "sql_server_102x102.png";
                break;
            }
            case Access: {
                fileName = "access_256x256.png";
            }
        }
        BufferedImage image = null;
        if (!BcStringUtil.isEmpty(fileName)) {
            image = ImageIO.read(XdtsImageUtil.class.getResourceAsStream("resources/" + fileName));
        }
        return image;
    }
}

