/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.ScfMmdServerUtil;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.module.xdts.common.XdtsSqlParser;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.dao.XdtsExtractionConditionDAO;
import jp.co.extreme.module.xdts.model.v0001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsExtractionConditionRMO
extends RmiAbstractRMO {
    public static final String METHOD_putEntity = "putEntity";
    public static final String METHOD_getEntity = "getEntity";
    String namePrefix;

    public XdtsExtractionConditionRMO() {
        this.namePrefix = BcWords.getInstance().extractionCondition + "-";
    }

    public void putEntity(RmiRmoArgument rmoArg) throws Exception {
        XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        extractionCondition.name = BcStringUtil.trim(extractionCondition.name);
        extractionCondition.group = XdtsUtil.reformPath(extractionCondition.group);
        XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
        if (BcStringUtil.isEmpty(extractionCondition.name)) {
            extractionCondition.name = this.createName(dtsSession, extractionCondition.profileId, extractionCondition.id, null, this.namePrefix);
            XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
        }
        rmoArg.getRespons().addData(extractionCondition);
    }

    public void deleteEntity(RmiRmoArgument rmoArg) throws Exception {
        Collection entityIdCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        int cnt = 0;
        for (Integer entityId : entityIdCollection) {
            extractionCondition.id = entityId;
            cnt += XdtsExtractionConditionDAO.getInstance().deleteEntity(dtsSession, extractionCondition);
        }
        rmoArg.getRespons().addData(cnt);
    }

    public void getEntity(RmiRmoArgument rmoArg) throws Exception {
        int entityId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsExtractionCondition extractionCondition = XdtsExtractionConditionDAO.getInstance().getById(dtsSession, entityId);
        rmoArg.getRespons().addData(extractionCondition);
    }

    public void getList(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List extractionConditionList = XdtsExtractionConditionDAO.getInstance().getList(dtsSession, profileId);
        rmoArg.getRespons().addData(extractionConditionList);
    }

    public void copyQueryContext(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        Collection extractionConditionIdCollection = (Collection)rmoArg.getRequest().getData();
        String group = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<XdtsExtractionCondition> extractionConditionList = new ArrayList<XdtsExtractionCondition>();
        Iterator iterator = extractionConditionIdCollection.iterator();
        while (iterator.hasNext()) {
            int extractionConditionId = (Integer)iterator.next();
            XdtsExtractionCondition extractionCondition = XdtsExtractionConditionDAO.getInstance().getById(dtsSession, extractionConditionId);
            extractionCondition.name = this.createName(dtsSession, extractionCondition.profileId, extractionCondition.id, extractionCondition.name, this.namePrefix);
            extractionCondition.id = -1;
            extractionCondition.profileId = profileId;
            extractionCondition.group = group;
            XdtsExtractionConditionDAO.getInstance().putEntity(dtsSession, extractionCondition);
            extractionConditionList.add(extractionCondition);
        }
        rmoArg.getRespons().addData(extractionConditionList);
    }

    public String createName(DtsSession dtsSession, int profileId, int entityId, String origName, String namePrefix) throws Exception {
        if (BcStringUtil.isEmpty(origName)) {
            origName = String.valueOf(namePrefix) + entityId;
        }
        String newName = BcStringUtil.toStringNotNull(origName);
        String baseName = null;
        int tryCnt = 0;
        while (true) {
            BcLogUtil.debug("newName=" + newName);
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)XdtsExtractionConditionDAO.getInstance().getByName(dtsSession, profileId, newName);
            if (extractionCondition == null) break;
            if (BcStringUtil.isEmpty(baseName) && BcStringUtil.isEmpty(baseName = EtcWordUtil.getBaseName(origName))) {
                baseName = origName;
            }
            newName = String.valueOf(baseName) + EtcEnumStrUtil.toElement(++tryCnt);
        }
        return newName;
    }

    public void createExtractionCondition(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        String query = rmoArg.getRequest().getDataAsString();
        BcLogUtil.debug("profileId=" + profileId + " query=" + query);
        DtsSession dtsSessionMain = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, profileId);
        DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);
        SqlContext sqlContextWk1 = dtsSessionWk1.getSqlContext();
        BcResult result = this.createExtractionCondition_L2(dtsSessionWk1, query, BcLogUtil.getDefaultLogger());
        if (!result.hasError()) {
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
            extractionCondition.profileId = profileId;
        }
        rmoArg.getRespons().addData(result);
    }

    public BcResult createExtractionCondition_L2(DtsSession dtsSession, String query, BcLogger logger) throws Exception {
        BcResult result = XdtsUtil.validateSql(query, false);
        if (result.hasError()) {
            return result;
        }
        List<MmdField> mmdFieldList = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            stmt.setMaxRows(1);
            ResultSet rs = stmt.executeQuery(query);
            List<String> columnNameList = null;
            Map<String, MmdField> mmdFieldMap = null;
            DtsWordManager wordManager = dtsSession.getSessionFactory().wordManager;
            mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rs.getMetaData(), columnNameList, mmdFieldMap, wordManager, Locale.getDefault());
            rs.close();
        }
        BcLogUtil.debug("mmdFieldList.size()=" + mmdFieldList.size());
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            BcLogUtil.debug("mmdField.tableColumnName=" + mmdField.tableColumnName);
            ++i;
        }
        XdtsSqlParser sqlParser = new XdtsSqlParser();
        XdtsExtractionCondition extractionCondition = sqlParser.createExtractionCondition(query);
        XdtsSqlParserUtil.createExtractionCondition(extractionCondition, mmdFieldList, logger);
        result.setUserObject(extractionCondition);
        return result;
    }

    public static enum Method implements RmiRemoteMethod
    {
        deleteEntity,
        getList,
        copyQueryContext,
        createExtractionCondition;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

