/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Map;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.stage.Window;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.FxxProgressIndicationPane;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.html.util.EtcHtmlUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.fx.XdtsDataImportWizard;
import jp.co.extreme.module.xdts.fx.XdtsDatasourcePane;
import jp.co.extreme.module.xdts.model.XdtsImportColumn;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.stub.XdtsImportStub;
import jp.co.extreme.scf4.fx.HfxProcessingPane;
import jp.co.extreme.scf4.fx.XdtsWizardPane;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.SqlWords;

class XdtsImportPanel3
extends XdtsWizardPane {
    FxBorderPane borderPane = new FxBorderPane();
    FxBorderPane topPane = new FxBorderPane();
    XdtsDatasourcePane destDatasourcePane = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.editDestination);
    FxFlowPane conditionPane1 = new FxFlowPane(11);
    FxTextField tableNameField = new FxTextField();
    BcTableColumnModel tableColumnModel;
    BcTableModel tableModel;
    FxTableView tableView;
    XdtsDataImportWizard wizard;

    public XdtsImportPanel3(XdtsDataImportWizard wizard) throws Exception {
        this.wizard = wizard;
    }

    @Override
    public void initComponent() throws Exception {
        XdtsImportColumn importColumn;
        super.initComponent();
        this.mainDecoratePane.setCenter((Node)this.borderPane);
        String description = "<html><font size=\"2\">\u30c6\u30fc\u30d6\u30eb\u540d\u3001DB\u5217\u540d\u3001\u53d6\u308a\u8fbc\u307f\u5148DB\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002<br>\u300c\u6b21\u3078\u300d\u30dc\u30bf\u30f3\u3092\u62bc\u4e0b\u306b\u3088\u308a\u53d6\u308a\u8fbc\u307f\u3092\u958b\u59cb\u3057\u307e\u3059\u3002</font></html>";
        this.mainDecoratePane.setDescription(description);
        this.conditionPane1.removeAll();
        this.borderPane.setTop((Node)this.topPane);
        if (this.wizard.profile != null) {
            this.destDatasourcePane.setData(this.wizard.profile);
        }
        this.destDatasourcePane.setPrefWidth(this.destDatasourcePane.getPrefWidth());
        this.topPane.setLeft((Node)this.destDatasourcePane);
        this.tableNameField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().tableName), new Node[]{this.tableNameField});
        this.conditionPane1.addNodeUnit(nodeUnit);
        this.topPane.setCenter((Node)this.conditionPane1);
        String tableName = BcFileUtil.getBaseName(this.wizard.importContext.file);
        if (!BcStringUtil.isEmpty(this.wizard.importContext.sheetName)) {
            tableName = String.valueOf(tableName) + "_" + this.wizard.importContext.sheetName;
        }
        tableName = XdtsUtil.toDbObjectName(tableName);
        this.tableNameField.setText(tableName);
        Map<Integer, XdtsImportColumn> columnaMap = this.wizard.importContext.columnaMap;
        int i = 0;
        while (i < columnaMap.size()) {
            importColumn = columnaMap.get(i);
            importColumn.dbColumnName = BcStringUtil.isEmpty(importColumn.columnName) ? XdtsUtil.createColumnName(i + 1) : XdtsUtil.toDbObjectName(importColumn.columnName);
            ++i;
        }
        this.tableView = new FxTableView();
        this.tableView.setEditable(true);
        this.tableColumnModel = this.createTableColumnModel();
        FxTableUtil.createColumn(this.tableColumnModel, this.tableView, null);
        this.tableModel = new BcTableModel(this.tableColumnModel);
        i = 0;
        while (i < columnaMap.size()) {
            importColumn = columnaMap.get(i);
            MmdField mmdField = this.createMmdField(importColumn);
            JDBCType jdbcType = SqlUtil.toJdbcType(mmdField.sqlTypeId);
            ArrayList<String> row = new ArrayList<String>();
            row.add(importColumn.columnName);
            row.add(BcNumberUtil.toString(importColumn.maxLength));
            row.add(BcNumberUtil.toString(importColumn.maxBigDecimal));
            row.add(BcNumberUtil.toString(importColumn.maxScale));
            row.add(importColumn.dbColumnName);
            row.add(jdbcType.name());
            this.tableModel.addRow(row);
            ++i;
        }
        FxTableRowList tableRowList = new FxTableRowList(this.tableModel);
        this.tableView.setItems(tableRowList);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.setEditable(true);
        this.borderPane.setCenter((Node)this.tableView);
        this.previousButton.setVisible(true);
        this.nextButton.setVisible(true);
        this.cancelButton.setVisible(true);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }

    @Override
    protected void previousButtonAction() throws Exception {
        this.wizard.phase2();
    }

    @Override
    protected void nextButtonAction() throws Exception {
        MmdModel mmdModel;
        BcResult result = this.validateInputValue();
        if (result.hasError()) {
            String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            FxOptionPane.showMessageDialog((Window)this.wizard.stage, (Object)msg, BcWords.getInstance().warning, 2);
            return;
        }
        this.wizard.importContext.mmdModel = mmdModel = new MmdModel();
        mmdModel.tableName = this.tableNameField.getText();
        if (this.wizard.importContext.importDefine.rowNumberEnabled) {
            MmdField mmdField = new MmdField();
            mmdField.columnName = "row_id";
            mmdField.sqlTypeId = 4;
            mmdModel.addField(mmdField);
            MmdIndex mmdIndex = new MmdIndex();
            mmdIndex.name = String.valueOf(mmdModel.tableName) + "__k01";
            MmdIndexElement indexElement = new MmdIndexElement(mmdField.columnName, 1, true);
            mmdIndex.indexElementList.add(indexElement);
            mmdModel.primaryIndexName = mmdIndex.name;
        }
        Map<Integer, XdtsImportColumn> columnaMap = this.wizard.importContext.columnaMap;
        int i = 0;
        while (i < columnaMap.size()) {
            XdtsImportColumn importColumn = columnaMap.get(i);
            MmdField mmdField = this.createMmdField(importColumn);
            mmdField.columnName = (String)this.tableModel.getValueAt(i, 4);
            mmdModel.addField(mmdField);
            ++i;
        }
        try {
            XdtsImportStub.getInstance().createTable(this.wizard.profile, this.wizard.importContext);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            FxOptionPane.showMessageDialog((Window)this.wizard.stage, (Object)message, BcWords.getInstance().error, 0);
            return;
        }
        FxxProgressIndicationPane progressIndicationPane = this.crateProgressIndicationPane();
        progressIndicationPane.msgLabel.setText(String.valueOf(BcWords.getInstance().inProgress) + "...");
        InnerTask task = new InnerTask();
        new Thread((Runnable)((Object)task)).start();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.wizard.closeConfirm();
    }

    protected BcResult validateInputValue() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        XdtsProfile profile2 = new XdtsProfile();
        this.destDatasourcePane.storeData(profile2);
        if (BcStringUtil.isEmpty(profile2.url)) {
            result.addError("\u53d6\u308a\u8fbc\u307f\u5148\u306e\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        } else {
            this.wizard.profile = profile2;
        }
        return result;
    }

    protected MmdField createMmdField(XdtsImportColumn importColumn) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.columnName = importColumn.dbColumnName;
        if (importColumn.isNumber) {
            mmdField.decimalDigit = importColumn.maxScale;
            mmdField.sqlTypeId = importColumn.maxScale > 0 ? 8 : (importColumn.maxBigDecimal == null ? 5 : (importColumn.maxBigDecimal.longValue() >= Integer.MIN_VALUE && importColumn.maxBigDecimal.longValue() <= Integer.MAX_VALUE ? 4 : -5));
        } else if (importColumn.maxLength > 254) {
            mmdField.sqlTypeId = -16;
        } else {
            mmdField.sqlTypeId = 12;
            mmdField.dataSize = importColumn.maxLength > 0 ? importColumn.maxLength : 1;
        }
        return mmdField;
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = String.valueOf(BcWords.getInstance().source) + " " + BcWords.getInstance().columnName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 32;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().maximumLength);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().maximumValue);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().maximumDecimalDigit);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "DB " + BcWords.getInstance().columnName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 24;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = EtcHtmlUtil.toHtml(SqlWords.getInstance().dataType);
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    protected void errorCatch(Exception ex) {
        final String message = ex.getMessage();
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                FxOptionPane.showMessageDialog((Window)XdtsImportPanel3.this.wizard.stage, (Object)message, BcWords.getInstance().warning, 2);
            }
        });
    }

    class InnerProcessingPane
    extends HfxProcessingPane {
        @Override
        protected void unLock() {
            super.unLock();
            try {
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((InnerProcessingPane)InnerProcessingPane.this).XdtsImportPanel3.this.wizard.phase_finish();
                        }
                        catch (Exception ex) {
                            XdtsImportPanel3.this.errorCatch(ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }

    class InnerTask
    extends Task {
        InnerTask() {
        }

        public Void call() {
            try {
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InnerProcessingPane processingPane = new InnerProcessingPane();
                            XdtsImportStub.getInstance().dataImport(((InnerTask)InnerTask.this).XdtsImportPanel3.this.wizard.profile, ((InnerTask)InnerTask.this).XdtsImportPanel3.this.wizard.importContext, (Window)((InnerTask)InnerTask.this).XdtsImportPanel3.this.wizard.stage, processingPane);
                        }
                        catch (Exception ex) {
                            XdtsImportPanel3.this.errorCatch(ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                XdtsImportPanel3.this.errorCatch(ex);
            }
            return null;
        }
    }
}

