/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcSortUtil;
import jp.co.extreme.module.xdts.common.XdtsPlainSelectExtractor;
import jp.co.extreme.module.xdts.common.XdtsSqlParser;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v0001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v0001.XdtsSelectColumn;
import jp.co.extreme.module.xdts.model.v0001.XdtsSelectContext;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlWhereElement;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;

public class XdtsQueryCreator
extends BcLoggableObject {
    XdtsSqlParser sqlParser = new XdtsSqlParser();
    XdtsPlainSelectExtractor plainSelectExtractor = new XdtsPlainSelectExtractor();

    public String createSelectQuery(SqlContext sqlContext, XdtsExtractionCondition extractionCondition, XdtsUserSetting userSetting) throws Exception {
        HashMap<String, String> subSelectrMap = new HashMap<String, String>();
        String query = null;
        int i = 0;
        while (i < extractionCondition.selectContextList.size()) {
            int idx = extractionCondition.selectContextList.size() + -i - 1;
            XdtsSelectContext selectContext = extractionCondition.selectContextList.get(idx);
            PlainSelect plainSelect = this.createPlainSelect(selectContext);
            query = plainSelect.toString();
            if (selectContext.rowLimit > 0L || selectContext.rowOffset > 0L) {
                query = sqlContext.setLimit(query, (int)selectContext.rowLimit, (int)selectContext.rowOffset).toString();
            }
            for (Map.Entry mapEntry : subSelectrMap.entrySet()) {
                query = BcStringUtil.replace((CharSequence)query, (CharSequence)mapEntry.getKey(), (CharSequence)mapEntry.getValue()).toString();
            }
            String placeholder = XdtsSqlParserUtil.toPlaceholderSubSelect(selectContext.id);
            subSelectrMap.put(placeholder, query);
            ++i;
        }
        return query;
    }

    public PlainSelect createPlainSelect(XdtsSelectContext selectContext) throws Exception {
        PlainSelect plainSelect = new PlainSelect();
        ArrayList<XdtsSelectColumn> selectColumnListWk = new ArrayList<XdtsSelectColumn>();
        int i = 0;
        while (i < selectContext.selectColumnList.size()) {
            XdtsSelectColumn selectColumn = selectContext.selectColumnList.get(i);
            if (selectColumn.order > 0) {
                selectColumnListWk.add(selectColumn);
            }
            ++i;
        }
        BcSortUtil.sort(selectColumnListWk, true, new Object[]{"order", "alias", "tableColumnName"});
        ArrayList<SelectExpressionItem> selectExpressionItemList = new ArrayList<SelectExpressionItem>();
        int i2 = 0;
        while (i2 < selectColumnListWk.size()) {
            XdtsSelectColumn selectColumn = (XdtsSelectColumn)selectColumnListWk.get(i2);
            Column column = new Column(selectColumn.tableColumnName.template);
            SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)column);
            if (!BcStringUtil.isEmpty(selectColumn.alias)) {
                Alias alias = new Alias(selectColumn.alias, true);
                selectExpressionItem.setAlias(alias);
            }
            selectExpressionItemList.add(selectExpressionItem);
            ++i2;
        }
        plainSelect.setSelectItems(selectExpressionItemList);
        Table table = new Table(selectContext.from.template);
        plainSelect.setFromItem((FromItem)table);
        plainSelect.setJoins(null);
        StringBuilder sb = new StringBuilder();
        if (selectContext.whereBase != null && !BcStringUtil.isEmpty(selectContext.whereBase.template)) {
            sb.append(selectContext.whereBase.template);
        }
        if (selectContext.wherecClauseSql != null) {
            int i3 = 0;
            while (i3 < selectContext.wherecClauseSql.getWhereElementList().size()) {
                SqlWhereElement whereElement = selectContext.wherecClauseSql.getWhereElementList().get(i3);
                if (sb.length() > 0) {
                    sb.append(" \n");
                    sb.append(whereElement.getLogical());
                    sb.append(" ");
                }
                sb.append(whereElement.getFormula());
                ++i3;
            }
        }
        if (BcStringUtil.isEmpty(sb)) {
            plainSelect.setWhere(null);
        } else {
            Column where = new Column(sb.toString());
            plainSelect.setWhere((Expression)where);
        }
        if (BcStringUtil.isEmpty(selectContext.groupBy)) {
            plainSelect.setGroupByElement(null);
        } else {
            GroupByElement groupByElement = new GroupByElement();
            Column column = new Column(selectContext.groupBy);
            groupByElement.addGroupByExpression((Expression)column);
            plainSelect.setGroupByElement(groupByElement);
        }
        if (selectContext.having != null) {
            if (BcStringUtil.isEmpty(selectContext.having.template)) {
                plainSelect.setHaving(null);
            } else {
                Column having = new Column(selectContext.having.template);
                plainSelect.setHaving((Expression)having);
            }
        }
        ArrayList<OrderByElement> orderByElementList = new ArrayList<OrderByElement>();
        OrderByElement orderByElement = new OrderByElement();
        Column column = new Column(selectContext.orderBy);
        orderByElement.setExpression((Expression)column);
        orderByElementList.add(orderByElement);
        plainSelect.setOrderByElements(orderByElementList);
        return plainSelect;
    }
}

