/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcEncoder;
import jp.co.extreme.base.util.BcParseEventHandler;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.module.impt.common.ImptAbstractRecordParser;
import jp.co.extreme.module.impt.common.ImptImportDataParser;
import jp.co.extreme.module.impt.common.ImptImportUtil;
import jp.co.extreme.module.impt.model.ImptImportDefine;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWorkbookParser;
import jp.co.extreme.module.xdts.model.XdtsImportColumn;
import jp.co.extreme.module.xdts.model.XdtsImportContext;

public class XdtsImportAnalysis
extends BcLoggableObject
implements BcParseEventHandler {
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    int mode;
    ImptImportDefine importDefine;
    Map<Integer, XdtsImportColumn> columnaMap;
    XdtsImportContext importContext;
    BcTableColumnModel tableColumnModel;
    BcTableModel tableModel;

    public BcTableModel doParse1(XdtsImportContext importContext) throws Exception {
        ImptAbstractRecordParser recordParser;
        this.importContext = importContext;
        this.mode = 1;
        this.importDefine = importContext.importDefine;
        this.importDefine.datasourceType = ImptImportUtil.getInstance().toDatasourceTypeByFileName(importContext.file.getName());
        if (this.importDefine.datasourceType == 11 || this.importDefine.datasourceType == 21) {
            this.importDefine.charsetName = BcEncoder.detectEncoding(importContext.file);
            recordParser = new ImptImportDataParser();
            recordParser.addEventHandler(this);
        } else if (this.importDefine.datasourceType == 31) {
            recordParser = new XdtsWorkbookParser(importContext);
            recordParser.addEventHandler(this);
        } else {
            throw new Exception("importDefine.datasourceType=" + this.importDefine.datasourceType);
        }
        this.tableColumnModel = new BcTableColumnModel();
        MmdField mmdField = new MmdField();
        mmdField.displayName = "\u884c";
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 6;
        BcTableColumn tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        this.tableColumnModel.addColumn(tableColumn);
        this.tableModel = new BcTableModel(this.tableColumnModel);
        FileInputStream fileInputStream = new FileInputStream(importContext.file);
        recordParser.doParse(this.importDefine, fileInputStream);
        return this.tableModel;
    }

    public void doParse2(XdtsImportContext importContext) throws Exception {
        ImptAbstractRecordParser recordParser;
        this.importContext = importContext;
        this.mode = 2;
        this.importDefine = importContext.importDefine;
        this.columnaMap = importContext.columnaMap;
        this.columnaMap.clear();
        if (this.importDefine.datasourceType == 11 || this.importDefine.datasourceType == 21) {
            recordParser = new ImptImportDataParser();
            recordParser.addEventHandler(this);
        } else if (this.importDefine.datasourceType == 31) {
            recordParser = new XdtsWorkbookParser(importContext);
            recordParser.addEventHandler(this);
        } else {
            throw new Exception("importDefine.formatType=" + this.importDefine.datasourceType);
        }
        FileInputStream fileInputStream = new FileInputStream(importContext.file);
        recordParser.doParse(this.importDefine, fileInputStream);
    }

    @Override
    public void parseStarted() throws Exception {
    }

    @Override
    public void parseFinished() throws Exception {
    }

    @Override
    public void parsedRow(int page, int row, int totalCnt, List<String> valueList) throws Exception {
        try {
            if (this.mode == 1) {
                this.parsedRow_mode1(page, row, totalCnt, valueList);
            } else if (this.mode == 2) {
                this.parsedRow_mode2(page, row, totalCnt, valueList);
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }

    protected void parsedRow_mode1(int page, int rowNo, int totalCnt, List valueList) throws Exception {
        ArrayList<Integer> row = new ArrayList<Integer>();
        row.add(totalCnt);
        int i = 0;
        while (i < valueList.size()) {
            Object value = valueList.get(i);
            row.add((Integer)value);
            if (i >= this.tableColumnModel.getColumnCount() - 1) {
                MmdField mmdField = new MmdField();
                mmdField.displayName = String.valueOf(BcWords.getInstance().column) + (i + 1);
                mmdField.dataClass = String.class;
                mmdField.columnCount = 10;
                BcTableColumn tableColumn = new BcTableColumn();
                tableColumn.setMmdField(mmdField);
                tableColumn.isEditable = false;
                this.tableModel.addColumn(tableColumn);
            }
            ++i;
        }
        BcTableUtil.addRow(this.tableModel, row);
    }

    protected void parsedRow_mode2(int page, int rowNo, int totalCnt, List valueList) throws Exception {
        if (rowNo < this.importDefine.headerRow) {
            return;
        }
        if (rowNo == this.importDefine.headerRow) {
            this.importDefine.setIndexRow(valueList);
            int i = 0;
            while (i < valueList.size()) {
                Object value = valueList.get(i);
                XdtsImportColumn importColumn = this.columnaMap.get(i);
                if (importColumn == null) {
                    importColumn = new XdtsImportColumn();
                    String strValue = BcStringUtil.toString(value);
                    importColumn.columnName = BcStringUtil.isEmpty(strValue) ? XdtsUtil.createColumnName(i + 1) : strValue;
                    this.columnaMap.put(i, importColumn);
                }
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < valueList.size()) {
            Object value = valueList.get(i);
            XdtsImportColumn importColumn = this.columnaMap.get(i);
            if (importColumn == null) {
                importColumn = new XdtsImportColumn();
                importColumn.columnName = XdtsUtil.createColumnName(i + 1);
                this.columnaMap.put(i, importColumn);
            }
            String strVal = "";
            if (value != null) {
                strVal = value.toString();
            }
            importColumn.maxLength = Math.max(importColumn.maxLength, strVal.length());
            if (importColumn.isNumber) {
                if (!BcNumberUtil.isNumber(strVal)) {
                    importColumn.isNumber = false;
                } else {
                    try {
                        BigDecimal bigDecimal = BcNumberUtil.parseBigDecimal(strVal);
                        importColumn.maxBigDecimal = importColumn.maxBigDecimal == null ? bigDecimal : bigDecimal.max(importColumn.maxBigDecimal);
                        importColumn.maxScale = Math.max(importColumn.maxScale, bigDecimal.scale());
                    }
                    catch (Exception ex) {
                        importColumn.isNumber = false;
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void characterDecodingException(int page, int row, int totalCnt, int columnIndex, byte[] bytes, Throwable throwable) throws Exception {
        this.getLogger().error(throwable);
    }
}

