/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.Calendar;
import java.util.List;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.etc.model.EtcColumnCondition;
import jp.co.extreme.etc.model.EtcGeneralCondition;
import jp.co.extreme.sql.SqlConditionParser;
import jp.co.extreme.sql.SqlConditionSpliter;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;
import jp.co.extreme.sql.model.SqlWherecQuery;

public class EtcSqlConditionUtil {
    private EtcSqlConditionUtil() throws Exception {
    }

    public static String createIndex(MmdIndex mmdIndex) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < mmdIndex.indexElementList.size()) {
            MmdIndexElement indexElement = mmdIndex.indexElementList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(indexElement.columnName);
            if (!indexElement.isAscending) {
                sb.append(" DESC");
            }
            ++i;
        }
        return sb.toString();
    }

    public static SqlSelectQuery createSelectQuery(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        List<String> tableColumnNameList = MmdUtil.toTableColumnNameList(mmdModel);
        selectQuery.getSelectColumnList().addAll(tableColumnNameList);
        selectQuery.setFromClause(mmdModel.tableName);
        return selectQuery;
    }

    public static EtcGeneralCondition createCondition(MmdModel mmdModel) throws Exception {
        EtcGeneralCondition condition = new EtcGeneralCondition();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            condition.orderByColumnNames = EtcSqlConditionUtil.createIndex(primaryKey);
        }
        return condition;
    }

    public static SqlSelectQuery createSelectQuery(SqlContext sqlContext, EtcGeneralCondition generalCondition) throws Exception {
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.getSelectColumnList().addAll(generalCondition.tableColumnNameList);
        selectQuery.setFromClause(generalCondition.fromClause);
        EtcSqlConditionUtil.createWhereClause(sqlContext, selectQuery, generalCondition);
        if (!BcStringUtil.isEmpty(generalCondition.orderByColumnNames)) {
            List<String> tokenList = BcStringUtil.stringTokenize(generalCondition.orderByColumnNames, BcStringUtil.COMMA_STR, true, true);
            selectQuery.getOrderByList().addAll(tokenList);
        }
        if (generalCondition.rowLimit >= 0) {
            selectQuery.rowOffset = 0;
            selectQuery.rowLimit = generalCondition.rowLimit;
        }
        return selectQuery;
    }

    public static void createWhereClause(SqlContext sqlContext, SqlSelectQuery selectQuery, EtcGeneralCondition generalCondition) throws Exception {
        for (EtcColumnCondition columnCondition : generalCondition.columnConditionList) {
            if (BcStringUtil.isEmpty(columnCondition.value)) continue;
            EtcSqlConditionUtil.createWhereClause_L2(sqlContext, selectQuery, columnCondition);
        }
    }

    public static void createWhereClause_L2(SqlContext sqlContext, SqlWherecQuery wherecQuery, EtcColumnCondition columnCondition) throws Exception {
        if (BcStringUtil.isEmpty(columnCondition.value)) {
            return;
        }
        if (SqlUtil.isNumber(columnCondition.sqlTypeId)) {
            SqlConditionParser.getInstance().parseCondition4Number(wherecQuery, sqlContext, columnCondition.tableColumnName, columnCondition.value);
        } else if (SqlUtil.isText(columnCondition.sqlTypeId)) {
            List<String> conditionValueList = SqlConditionSpliter.getInstance().split(columnCondition.value);
            if (conditionValueList.size() > 0) {
                String tmpStr = sqlContext.createPatternMatchClause(columnCondition.tableColumnName, columnCondition.patternMatch, true, false, conditionValueList);
                BcLogUtil.debug("tmpStr=" + tmpStr);
                SqlWhereElement whereElement = new SqlWhereElement();
                if (columnCondition.isAnd) {
                    whereElement.setLogical_AND();
                } else {
                    whereElement.setLogical_OR();
                }
                whereElement.setFormula(tmpStr);
                wherecQuery.addWhereElement(whereElement);
            }
        } else if (SqlUtil.isBoolean(columnCondition.sqlTypeId)) {
            Boolean bool = BcBooleanUtil.parseBoolean(columnCondition.value, true);
            if (bool != null) {
                SqlWhereElement whereElement = new SqlWhereElement();
                whereElement.setLogical_AND();
                if (columnCondition.sqlTypeId == -7) {
                    whereElement.setFormula(sqlContext.toCondition_number("=", BcBooleanUtil.toShort(bool)));
                } else {
                    whereElement.setFormula(sqlContext.toCondition_boolean(columnCondition.tableColumnName, bool, true));
                }
                wherecQuery.addWhereElement(whereElement);
            }
        } else if (columnCondition.sqlTypeId == 91 || columnCondition.sqlTypeId == 93) {
            List<String> valueList = BcCsvUtil.parseCsvRow(columnCondition.value, true);
            Calendar calendar1 = BcTimeUtil.toCalendar(valueList.get(0));
            Calendar calendar2 = BcTimeUtil.toCalendar(valueList.get(1));
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (columnCondition.sqlTypeId == 91) {
                whereElement.setFormula(sqlContext.toCondition_period_date(columnCondition.tableColumnName, calendar1, calendar2));
            } else {
                whereElement.setFormula(sqlContext.toCondition_period_datetime(columnCondition.tableColumnName, calendar1, calendar2));
            }
            wherecQuery.addWhereElement(whereElement);
        } else {
            BcLogUtil.debug("Not suppoted JDBC Type. " + columnCondition.sqlTypeId + ":" + SqlUtil.toJdbcType(columnCondition.sqlTypeId));
        }
    }
}

