/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.model.Wbs1PointHeader;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1PointHeaderDAO
extends OrmAbstractDAO<Wbs1PointHeader> {
    private Wbs1PointHeaderDAO() {
        super(new Wbs1PointHeader[0]);
        this.setTableName("wbs1_point_header");
    }

    public static Wbs1PointHeaderDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, long personId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (personId > 0L) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + personId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long personId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, personId);
        String sql = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("sql=" + sql);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> T getByPersonId(DtsSession dtsSession, long personId) throws Exception {
        if (personId <= 0L) {
            return null;
        }
        List<T> entityList = this.getList(dtsSession, Mode.personId, personId);
        return BcCollectionUtil.getFirst(entityList);
    }

    public Wbs1PointHeader getByPersonIdCreate(DtsSession dtsSession, long personId) throws Exception {
        Wbs1PointHeader pointHeader = (Wbs1PointHeader)this.getByPersonId(dtsSession, personId);
        if (pointHeader == null) {
            pointHeader = new Wbs1PointHeader();
            pointHeader.personId = personId;
        }
        return pointHeader;
    }

    /* synthetic */ Wbs1PointHeaderDAO(Wbs1PointHeaderDAO wbs1PointHeaderDAO) {
        this();
    }

    public static enum Mode {
        personId("person_id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1PointHeaderDAO instance = new Wbs1PointHeaderDAO(null);

        private SingletonHolder() {
        }
    }
}

