/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.common.Wbs1MailConstants;
import jp.co.extreme.module.wbs1.model.Wbs1Mail;
import jp.co.extreme.module.wbs1.model.WbsMailCondition;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1MailDAO
extends OrmAbstractDAO<Wbs1Mail> {
    static Map<String, Wbs1MailDAO> instanceMap = new HashMap<String, Wbs1MailDAO>();

    private Wbs1MailDAO() {
        super(new Wbs1Mail[0]);
    }

    public static Wbs1MailDAO getInstance(String tableName) {
        Wbs1MailDAO instance = instanceMap.get(tableName);
        if (instance == null) {
            instance = new Wbs1MailDAO();
            instance.setTableName(tableName);
            instanceMap.put(tableName, instance);
        }
        return instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, WbsMailCondition mailCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (mailCondition.mailId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + mailCondition.mailId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(mailCondition.mailFrom)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "from_ " + sqlContext.toCondition("=", mailCondition.mailFrom));
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(mailCondition.mailTo)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "to_ " + sqlContext.toCondition("=", mailCondition.mailTo));
            selectQuery.addWhereElement(whereElement);
        }
        this.getLogger().debug("mailCondition.mailStatus=" + (Object)((Object)mailCondition.mailStatus));
        if (mailCondition.mailStatus == Wbs1MailConstants.MailStatus.Draft) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "fair_copy_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (mailCondition.mailStatus == Wbs1MailConstants.MailStatus.Unsent) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "fair_copy_datetime Is Not Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "send_end_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (mailCondition.mailStatus == Wbs1MailConstants.MailStatus.NotOpened) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "send_end_datetime Is Not Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "open_datetime Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (mailCondition.mailStatus == Wbs1MailConstants.MailStatus.Opened) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "open_datetime Is Not Null");
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, WbsMailCondition mailCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, mailCondition);
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> T getById(DtsSession dtsSession, long id) throws Exception {
        WbsMailCondition mailCondition = new WbsMailCondition();
        mailCondition.mailId = id;
        mailCondition.mailStatus = Wbs1MailConstants.MailStatus.NULL;
        List<T> entityList = this.getList(dtsSession, Mode.id, mailCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    public static enum Mode {
        id("id"),
        from("from_"),
        to("to_");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }
}

