/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.List;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.model.Wbs1Attendance;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1AttendanceDAO
extends OrmAbstractDAO<Wbs1Attendance> {
    public static final int MODE_default = 1;
    public static final int MODE_personId = 2;
    public static final int MODE_startDate = 3;

    private Wbs1AttendanceDAO() {
        super(new Wbs1Attendance[0]);
        this.setTableName("wbs1_attendance");
    }

    public static Wbs1AttendanceDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, long attendanceId, long personId, long workspaceId, int startDate, int endDate) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (attendanceId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + attendanceId);
            selectQuery.addWhereElement(whereElement);
        }
        if (personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id = " + personId);
            selectQuery.addWhereElement(whereElement);
        }
        if (workspaceId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "workspace_id = " + workspaceId);
            selectQuery.addWhereElement(whereElement);
        }
        if (startDate > 0 || endDate > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_yyyyMMdd(String.valueOf(aliasWk) + "start_date", startDate, endDate));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
        } else if (mode == 2) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "person_id");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "start_date");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "start_time");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "end_date");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "end_time");
        } else if (mode == 3) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "workspace_id");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "start_date");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "start_time");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "end_date");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "end_time");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public List<Wbs1Attendance> getList(DtsSession dtsSession, int mode, long attendanceId, long personId, long workspaceId, int startDate, int endDate) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, attendanceId, personId, workspaceId, startDate, endDate);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public Wbs1Attendance getById(DtsSession dtsSession, long attendanceId) throws Exception {
        if (attendanceId <= 0L) {
            return null;
        }
        long personId = -1L;
        long workspaceId = -1L;
        List<Wbs1Attendance> entityList = this.getList(dtsSession, 1, attendanceId, personId, workspaceId, -1, -1);
        return BcCollectionUtil.getFirst(entityList);
    }

    public List<Wbs1Attendance> getListByPersonId(DtsSession dtsSession, long personId, long workspaceId, int startDate, int endDate) throws Exception {
        if (personId <= 0L) {
            return null;
        }
        long attendanceId = -1L;
        return this.getList(dtsSession, 2, attendanceId, personId, workspaceId, startDate, endDate);
    }

    public List<Wbs1Attendance> getListByPeriod(DtsSession dtsSession, long workspaceId, int startDate, int endDate) throws Exception {
        long attendanceId = -1L;
        long personId = -1L;
        return this.getList(dtsSession, 3, attendanceId, personId, workspaceId, startDate, endDate);
    }

    /* synthetic */ Wbs1AttendanceDAO(Wbs1AttendanceDAO wbs1AttendanceDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1AttendanceDAO instance = new Wbs1AttendanceDAO(null);

        private SingletonHolder() {
        }
    }
}

