/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tmnl.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.tmnl.model.TmnlTerminalType;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf8.cluster.controller.KscfMulticastData;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class TmnlTerminalTypeDAO
extends OrmAbstractDAO {
    private String tableName;
    private Map<Integer, TmnlTerminalType> dataIdMap;
    private Map<String, TmnlTerminalType> userAgentMap;
    private TmnlTerminalType terminalTypePc;

    private TmnlTerminalTypeDAO() {
        super(new Object[0]);
        this.setTableName("tmnl_terminal_type");
        this.dataIdMap = new HashMap<Integer, TmnlTerminalType>();
        this.userAgentMap = new HashMap<String, TmnlTerminalType>();
        this.terminalTypePc = new TmnlTerminalType();
        this.terminalTypePc.browserClassId = 11;
    }

    public static TmnlTerminalTypeDAO getInstance() {
        return SingletonHolder.instance;
    }

    public void multicastPacketReceived(KscfMulticastData multicastData, Object dataObject) throws Exception {
        Object[] dataArray = (Object[])dataObject;
        String methodName = dataArray[0].toString();
        BcLogUtil.debug("multicastPacketReceived.methodName=" + methodName);
        if (!BcStringUtil.equals(methodName, "removeTerminalTypeCash")) {
            throw new Exception("multicastPacketReceived.methodName=" + methodName);
        }
        int terminalTypeId = (Integer)dataArray[1];
        this.removeTerminalTypeCash(terminalTypeId, false);
    }

    public void removeTerminalTypeCash(int terminalTypeId, boolean doNitify) throws Exception {
        this.dataIdMap.remove(terminalTypeId);
    }

    protected List<String> getUpdateColumnList() throws Exception {
        if (this.updateColumnList != null) {
            return this.updateColumnList;
        }
        this.updateColumnList = new ArrayList();
        this.updateColumnList.add("name");
        this.updateColumnList.add("terminal_department_id");
        this.updateColumnList.add("profile");
        this.updateColumnList.add("browser_class_id");
        this.updateColumnList.add("html_version");
        this.updateColumnList.add("image_format");
        this.updateColumnList.add("sound_format");
        this.updateColumnList.add("image_01_width");
        this.updateColumnList.add("image_01_height");
        this.updateColumnList.add("image_02_width");
        this.updateColumnList.add("image_02_height");
        this.updateColumnList.add("resource_generation");
        this.updateColumnList.add("function_01");
        this.updateColumnList.add("note_");
        return this.updateColumnList;
    }

    public List<Object> toValueList(Object dataObject) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        TmnlTerminalType terminalType = (TmnlTerminalType)dataObject;
        valueList.add(terminalType.name);
        valueList.add(terminalType.terminalGroupId);
        valueList.add(terminalType.profile);
        valueList.add(terminalType.browserClassId);
        valueList.add(terminalType.htmlVersion);
        valueList.add(terminalType.imageFormat);
        valueList.add(terminalType.soundFormat);
        valueList.add(terminalType.image01Width);
        valueList.add(terminalType.image01Height);
        valueList.add(terminalType.image02Width);
        valueList.add(terminalType.image02Height);
        valueList.add(terminalType.resourceGeneration);
        valueList.add(terminalType.function01);
        valueList.add(terminalType.note);
        return valueList;
    }

    protected String getSelectColumns01(String tableAlias) throws Exception {
        String asTable2 = null;
        asTable2 = BcStringUtil.isEmpty(tableAlias) ? " ," : " ," + tableAlias + ".";
        String selectColumns = this.getPersistenceProxy().createCommonSelectPhrase(TmnlTerminalType.class, tableAlias) + asTable2 + "name" + asTable2 + "terminal_department_id" + asTable2 + "browser_class_id" + asTable2 + "profile" + asTable2 + "html_version" + asTable2 + "image_format" + asTable2 + "sound_format" + asTable2 + "image_01_width" + asTable2 + "image_01_height" + asTable2 + "image_02_width" + asTable2 + "image_02_height" + asTable2 + "resource_generation" + asTable2 + "function_01" + asTable2 + "note_";
        return selectColumns;
    }

    public void putTerminalType2(DtsSession dtsSession, TmnlTerminalType terminalType) throws Exception {
        List<String> columnList = this.getUpdateColumnList();
        List<Object> valueList = this.toValueList(terminalType);
        this.getPersistenceProxy().putEntity(dtsSession, this.tableName, columnList, valueList, terminalType);
    }

    public void putTerminalType(DtsSession dtsSession, TmnlTerminalType terminalType) throws Exception {
        this.removeTerminalTypeCash(terminalType.getDataId(), true);
        this.putTerminalType2(dtsSession, terminalType);
    }

    public int deleteTerminalType(DtsSession dtsSession, int terminalTypeId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int deletedCount = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            StringBuilder queryBuf = new StringBuilder(256);
            queryBuf.append(" DELETE FROM tmnl_terminal_type WHERE id=" + terminalTypeId);
            deletedCount = stmt.executeUpdate(queryBuf.toString());
        }
        this.removeTerminalTypeCash(terminalTypeId, true);
        return deletedCount;
    }

    protected boolean getTerminalType(DtsSession dtsSession, int terminalTypeId, TmnlTerminalType terminalType) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        boolean resValue = false;
        String query = " SELECT " + this.getSelectColumns01(null) + " FROM" + " " + this.tableName + " WHERE" + " id=" + terminalTypeId;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                this.getTerminalType(dtsSession, rs, columnIndex, terminalType);
                resValue = true;
            }
            rs.close();
        }
        return resValue;
    }

    protected void getTerminalType(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, TmnlTerminalType terminalType) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, terminalType);
        terminalType.name = rs.getString(columnIndex);
        terminalType.terminalGroupId = rs.getShort(columnIndex);
        terminalType.browserClassId = rs.getShort(columnIndex);
        terminalType.profile = rs.getString(columnIndex);
        terminalType.htmlVersion = rs.getShort(columnIndex);
        terminalType.imageFormat = rs.getShort(columnIndex);
        terminalType.soundFormat = rs.getShort(columnIndex);
        terminalType.image01Width = rs.getShort(columnIndex);
        terminalType.image01Height = rs.getShort(columnIndex);
        terminalType.image02Width = rs.getShort(columnIndex);
        terminalType.image02Height = rs.getShort(columnIndex);
        terminalType.resourceGeneration = rs.getShort(columnIndex);
        terminalType.function01 = rs.getShort(columnIndex);
        terminalType.note = rs.getString(columnIndex);
    }

    private TmnlTerminalType getTerminalType(DtsSession dtsSession, int terminalTypeId) throws Exception {
        TmnlTerminalType terminalType = this.dataIdMap.get(terminalTypeId);
        if (terminalType == null) {
            terminalType = this.getTerminalType2(dtsSession, terminalTypeId);
            if (terminalType == null) {
                return null;
            }
            this.dataIdMap.put(terminalType.getDataId(), terminalType);
            return terminalType;
        }
        return terminalType;
    }

    private TmnlTerminalType getTerminalType2(DtsSession dtsSession, int terminalTypeId) throws Exception {
        TmnlTerminalType terminalType = new TmnlTerminalType();
        if (this.getTerminalType(dtsSession, terminalTypeId, terminalType)) {
            return terminalType;
        }
        return null;
    }

    protected int getTerminalTypeIdByUserAgent(DtsSession dtsSession, String userAgent) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        int resValue = -1;
        String query = " SELECT terminal_type_id FROM tmnl_terminal_user_agent WHERE user_agent" + sqlContext.toCondition_string("=", userAgent);
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                resValue = rs.getInt(columnIndex);
            }
            rs.close();
        }
        return resValue;
    }

    protected TmnlTerminalType getTerminalTypeByUserAgent1(DtsSession dtsSession, String userAgent) throws Exception {
        int terminalTypeId = this.getTerminalTypeIdByUserAgent(dtsSession, userAgent);
        if (terminalTypeId > 0) {
            return this.getTerminalType(dtsSession, terminalTypeId);
        }
        return null;
    }

    public TmnlTerminalType getTerminalTypeByUserAgent(DtsSession dtsSession, String userAgent) throws Exception {
        if (BcStringUtil.isEmpty(userAgent)) {
            return null;
        }
        TmnlTerminalType terminalType = this.userAgentMap.get(userAgent);
        if (terminalType != null) {
            return terminalType;
        }
        if (this.userAgentMap.containsKey(userAgent)) {
            return null;
        }
        String userAgent2 = null;
        String tmpStr = userAgent;
        if (userAgent.startsWith("J-PHONE")) {
            int pos = userAgent.indexOf(" ");
            if (pos >= 0) {
                tmpStr = userAgent.substring(0, pos);
            }
            ArrayList<String> elementList = new ArrayList<String>();
            BcStringUtil.stringTokenize(tmpStr, "/", false, true, elementList);
            userAgent2 = elementList.size() > 3 ? BcStringUtil.marge(elementList.subList(0, 3), "/").toString() : tmpStr;
        } else if (userAgent.startsWith("Vodafone")) {
            int pos = userAgent.indexOf(" ");
            if (pos >= 0) {
                tmpStr = userAgent.substring(0, pos);
            }
            ArrayList<String> elementList = new ArrayList<String>();
            BcStringUtil.stringTokenize(tmpStr, "/", false, true, elementList);
            userAgent2 = BcStringUtil.marge(elementList.subList(0, 4), "/").toString();
        } else if (userAgent.startsWith("SoftBank")) {
            int pos = userAgent.indexOf(" ");
            if (pos >= 0) {
                tmpStr = userAgent.substring(0, pos);
            }
            ArrayList<String> elementList = new ArrayList<String>();
            BcStringUtil.stringTokenize(tmpStr, "/", false, true, elementList);
            userAgent2 = BcStringUtil.marge(elementList.subList(0, 4), "/").toString();
        } else if (userAgent.indexOf("UP.Browser") >= 0) {
            int pos = 0;
            pos = userAgent.startsWith("KDDI") ? userAgent.indexOf("/") : userAgent.indexOf(" ");
            if (pos >= 0) {
                tmpStr = userAgent.substring(0, pos);
            }
            userAgent2 = tmpStr;
        } else {
            userAgent2 = userAgent;
        }
        terminalType = this.getTerminalTypeByUserAgent1(dtsSession, userAgent2);
        if (terminalType == null) {
            terminalType = this.getTerminalTypeUndifined(dtsSession, userAgent2);
        }
        this.userAgentMap.put(userAgent, terminalType);
        if (terminalType == null) {
            BcLogUtil.info("unknown user_aganet='" + userAgent + "'");
        }
        return terminalType;
    }

    public TmnlTerminalType getTerminalTypePc() {
        return this.terminalTypePc;
    }

    public TmnlTerminalType getTerminalTypeUndifined(DtsSession dtsSession, String userAgent) throws Exception {
        if (BcStringUtil.isEmpty(userAgent)) {
            return null;
        }
        TmnlTerminalType terminalType = null;
        if (userAgent.startsWith("DoCoMo")) {
            terminalType = new TmnlTerminalType();
            terminalType.setNewestTerminalType();
        } else if (userAgent.startsWith("KDDI")) {
            terminalType = new TmnlTerminalType();
            terminalType.setNewestTerminalType((short)4, (short)4);
        } else if (userAgent.indexOf("UP.Browser") >= 0) {
            terminalType = new TmnlTerminalType();
            terminalType.setNewestTerminalType((short)4, (short)4);
        } else if (userAgent.startsWith("Vodafone")) {
            terminalType = new TmnlTerminalType();
            terminalType.setNewestTerminalType((short)3, (short)2);
        } else if (userAgent.startsWith("J-PHONE")) {
            terminalType = new TmnlTerminalType();
            terminalType.setNewestTerminalType((short)3, (short)2);
        } else if (userAgent.startsWith("SoftBank")) {
            terminalType = new TmnlTerminalType();
            terminalType.setNewestTerminalType((short)3, (short)2);
        }
        return terminalType;
    }

    /* synthetic */ TmnlTerminalTypeDAO(TmnlTerminalTypeDAO tmnlTerminalTypeDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final TmnlTerminalTypeDAO instance = new TmnlTerminalTypeDAO(null);

        private SingletonHolder() {
        }
    }
}

